/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.api.gui.IClientActionGui;
import com.feed_the_beast.ftbl.lib.gui.PlayerHeadImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;

public class FTBLibClient {
    public static final Frustum FRUSTUM = new Frustum();
    public static final Map<String, ResourceLocation> CACHED_SKINS = new HashMap<String, ResourceLocation>();
    public static boolean isFirstPerson;
    public static int currentDim;
    public static int playerPosHash;
    public static double playerX;
    public static double playerY;
    public static double playerZ;
    public static double renderX;
    public static double renderY;
    public static double renderZ;
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static EntityItem entityItem;
    public static PlayerHeadImage localPlayerHead;

    public static int getDim() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null ? mc.field_71441_e.field_73011_w.getDimension() : 0;
    }

    public static void spawnPart(Particle e) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(e);
    }

    public static void onGuiClientAction() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof IClientActionGui) {
            ((IClientActionGui)screen).onClientDataChanged();
        }
    }

    public static void pushMaxBrightness() {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void popMaxBrightness() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static ITextureObject bindTexture(ResourceLocation texture) {
        TextureManager t = Minecraft.func_71410_x().func_110434_K();
        ITextureObject textureObject = t.func_110581_b(texture);
        if (textureObject == null) {
            textureObject = new SimpleTexture(texture);
            t.func_110579_a(texture, textureObject);
        }
        GlStateManager.func_179144_i((int)textureObject.func_110552_b());
        return textureObject;
    }

    public static ITextureObject getDownloadImage(ResourceLocation out, String url, ResourceLocation def, @Nullable IImageBuffer buffer) {
        TextureManager t = Minecraft.func_71410_x().func_110434_K();
        ITextureObject img = t.func_110581_b(out);
        if (img == null) {
            img = new ThreadDownloadImageData(null, url, def, buffer);
            t.func_110579_a(out, img);
        }
        return img;
    }

    public static void execClientCommand(String s, boolean printChat) {
        Minecraft mc = Minecraft.func_71410_x();
        if (printChat) {
            mc.field_71456_v.func_146158_b().func_146239_a(s);
        }
        if (ClientCommandHandler.instance.func_71556_a((ICommandSender)mc.field_71439_g, s) == 0) {
            mc.field_71439_g.func_71165_d(s);
        }
    }

    public static void execClientCommand(String s) {
        FTBLibClient.execClientCommand(s, false);
    }

    public static ResourceLocation getSkinTexture(String username) {
        ResourceLocation r = CACHED_SKINS.get(username);
        if (r == null) {
            r = AbstractClientPlayer.func_110311_f((String)username);
            try {
                AbstractClientPlayer.func_110304_a((ResourceLocation)r, (String)username);
                CACHED_SKINS.put(username, r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    public static void renderItem(World w, ItemStack is) {
        if (entityItem == null) {
            entityItem = new EntityItem(w);
        }
        FTBLibClient.entityItem.field_70170_p = w;
        FTBLibClient.entityItem.field_70290_d = 0.0f;
        entityItem.func_92058_a(is);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB bb) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void updateRenderInfo() {
        Minecraft mc = Minecraft.func_71410_x();
        isFirstPerson = mc.field_71474_y.field_74320_O == 0;
        currentDim = FTBLibClient.getDim();
        playerX = mc.func_175598_ae().field_78730_l;
        playerY = mc.func_175598_ae().field_78731_m;
        playerZ = mc.func_175598_ae().field_78728_n;
        renderX = TileEntityRendererDispatcher.field_147554_b;
        renderY = TileEntityRendererDispatcher.field_147555_c;
        renderZ = TileEntityRendererDispatcher.field_147552_d;
        playerPosHash = Objects.hash(currentDim, playerX, playerY, playerZ);
        FRUSTUM.func_78547_a(playerX, playerY, playerZ);
    }
}

