/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.util.LMNetUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MyTeamPlayerData
implements Comparable<MyTeamPlayerData> {
    public final UUID playerId;
    public final String playerName;
    public boolean isOnline;
    public EnumTeamStatus status;

    public MyTeamPlayerData(IForgePlayer player, EnumTeamStatus s) {
        this.playerId = player.getId();
        this.playerName = player.getName();
        this.isOnline = player.isOnline();
        this.status = s;
    }

    public MyTeamPlayerData(ByteBuf io) {
        this.playerId = LMNetUtils.readUUID(io);
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.isOnline = io.readBoolean();
        this.status = EnumTeamStatus.VALUES[io.readByte()];
    }

    public void write(ByteBuf io) {
        LMNetUtils.writeUUID(io, this.playerId);
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.playerName);
        io.writeBoolean(this.isOnline);
        io.writeByte(this.status.ordinal());
    }

    @Override
    public int compareTo(MyTeamPlayerData o) {
        int i = o.status.getStatus() - this.status.getStatus();
        if (i == 0 && (i = Boolean.compare(o.isOnline, this.isOnline)) == 0) {
            i = this.playerName.compareToIgnoreCase(o.playerName);
        }
        return i;
    }
}

