/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IGui;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.client.TexturelessRectangle;
import com.feed_the_beast.ftbl.lib.gui.ButtonLM;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLM;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.TextBoxLM;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class GuiCreateTeam
extends GuiLM {
    private EnumTeamColor color = EnumTeamColor.VALUES[MathHelperLM.RAND.nextInt(EnumTeamColor.VALUES.length)];
    private final ButtonLM buttonAccept;
    private final ButtonLM buttonCancel;
    private final List<ButtonLM> colorButtons;
    private final TextBoxLM textBoxId;

    public GuiCreateTeam() {
        super(154, 102);
        int bwidth = this.getWidth() / 2 - 6;
        this.buttonAccept = new ButtonLM(this.getWidth() - bwidth - 4, this.getHeight() - 20, bwidth, 16){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                if (!GuiCreateTeam.this.textBoxId.getText().isEmpty()) {
                    FTBLibClient.execClientCommand("/ftb team create " + GuiCreateTeam.this.textBoxId.getText() + " " + GuiCreateTeam.this.color.func_176610_l());
                    gui.closeGui();
                }
            }

            @Override
            public int renderTitleInCenter(IGui gui) {
                return gui.getTextColor();
            }
        };
        this.buttonAccept.setTitle(GuiLang.BUTTON_ACCEPT.translate(new Object[0]));
        this.buttonAccept.setIcon(ButtonLM.DEFAULT_BACKGROUND);
        this.buttonCancel = new ButtonLM(4, this.getHeight() - 20, bwidth, 16){

            @Override
            public void onClicked(IGui gui, IMouseButton button) {
                GuiHelper.playClickSound();
                gui.closeGui();
            }

            @Override
            public int renderTitleInCenter(IGui gui) {
                return gui.getTextColor();
            }
        };
        this.buttonCancel.setTitle(GuiLang.BUTTON_CANCEL.translate(new Object[0]));
        this.buttonCancel.setIcon(ButtonLM.DEFAULT_BACKGROUND);
        this.textBoxId = new TextBoxLM(4, 4, this.getWidth() - 8, 16){

            @Override
            public void onTextChanged(IGui gui) {
                this.setText(gui, LMStringUtils.getID(this.getText(), 14), false);
            }
        };
        this.textBoxId.writeText(this, this.mc.field_71439_g.func_146103_bH().getName().toLowerCase());
        this.textBoxId.background = ButtonLM.DEFAULT_BACKGROUND;
        this.textBoxId.ghostText = TextFormatting.ITALIC.toString() + TextFormatting.DARK_GRAY + "Enter ID";
        this.textBoxId.textColor = this.color.getColor();
        this.textBoxId.setFocused(true);
        this.textBoxId.charLimit = 35;
        this.colorButtons = new ArrayList<ButtonLM>();
        for (int i = 0; i < EnumTeamColor.VALUES.length; ++i) {
            final int i1 = i;
            ButtonLM b = new ButtonLM(4 + i % 5 * 30, 24 + i / 5 * 30, 25, 25){

                @Override
                public void onClicked(IGui gui, IMouseButton button) {
                    GuiCreateTeam.this.color = EnumTeamColor.VALUES[i1];
                    ((GuiCreateTeam)GuiCreateTeam.this).textBoxId.textColor = GuiCreateTeam.this.color.getColor();
                }
            };
            b.setIcon(new TexturelessRectangle(EnumTeamColor.VALUES[i].getColor()).setLineColor(GuiCreateTeam.DEFAULT_BACKGROUND.lineColor).setRoundEdges(true));
            b.setTitle(EnumTeamColor.VALUES[i].getTextFormatting() + EnumTeamColor.VALUES[i].getLangKey().translate(new Object[0]));
            this.colorButtons.add(b);
        }
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.addAll(this.colorButtons);
        this.add(this.textBoxId);
    }

    @Override
    public IDrawableObject getIcon(IGui gui) {
        return DEFAULT_BACKGROUND;
    }
}

