/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.api.events.universe.ForgeUniverseClosedEvent;
import com.feed_the_beast.ftbl.api.events.universe.ForgeUniverseLoadedBeforePlayersEvent;
import com.feed_the_beast.ftbl.api.events.universe.ForgeUniverseLoadedEvent;
import com.feed_the_beast.ftbl.api.events.universe.ForgeUniversePostLoadedEvent;
import com.feed_the_beast.ftbl.api_impl.ForgePlayer;
import com.feed_the_beast.ftbl.api_impl.ForgePlayerFake;
import com.feed_the_beast.ftbl.api_impl.ForgeTeam;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.lib.NBTDataStorage;
import com.feed_the_beast.ftbl.lib.util.LMFileUtils;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMNBTUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Universe
implements IUniverse {
    public static Universe INSTANCE = null;
    private static final Map<UUID, ForgePlayerFake> FAKE_PLAYER_MAP = new HashMap<UUID, ForgePlayerFake>();
    public final Map<UUID, ForgePlayer> playerMap = new HashMap<UUID, ForgePlayer>();
    public final Map<String, ForgeTeam> teams = new HashMap<String, ForgeTeam>();
    private NBTDataStorage dataStorage;

    public void load() {
        this.dataStorage = FTBLibMod.PROXY.createDataStorage(this, FTBLibModCommon.DATA_PROVIDER_UNIVERSE);
        MinecraftForge.EVENT_BUS.post((Event)new ForgeUniverseLoadedEvent(this));
        try {
            JsonElement worldData = LMJsonUtils.fromJson(new File(LMUtils.folderWorld, "world_data.json"));
            if (worldData.isJsonObject()) {
                SharedServerData.INSTANCE.func_152753_a((JsonElement)worldData.getAsJsonObject());
            }
            this.playerMap.clear();
            this.teams.clear();
            File oldFile = new File(LMUtils.folderWorld, "data/FTBLib.dat");
            if (oldFile.exists()) {
                NBTTagCompound nbt = LMNBTUtils.readTag(oldFile);
                MinecraftForge.EVENT_BUS.post((Event)new ForgeUniverseLoadedBeforePlayersEvent(this));
                NBTTagList list = nbt.func_150295_c("Players", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    UUID id = LMStringUtils.fromString(tag.func_74779_i("UUID"));
                    if (id == null) continue;
                    ForgePlayer forgePlayer = new ForgePlayer(id, tag.func_74779_i("Name"));
                    forgePlayer.deserializeNBT(tag);
                    this.playerMap.put(id, forgePlayer);
                }
                NBTTagList teamsTag = nbt.func_150295_c("Teams", 10);
                for (int i = 0; i < teamsTag.func_74745_c(); ++i) {
                    NBTTagCompound tag2 = teamsTag.func_150305_b(i);
                    ForgeTeam forgeTeam = new ForgeTeam(tag2.func_74779_i("ID"));
                    forgeTeam.deserializeNBT(tag2);
                    this.teams.put(forgeTeam.func_176610_l(), forgeTeam);
                }
                MinecraftForge.EVENT_BUS.post((Event)new ForgeUniversePostLoadedEvent(this));
                if (this.dataStorage != null) {
                    this.dataStorage.deserializeNBT(nbt.func_74764_b("ForgeCaps") ? nbt.func_74775_l("ForgeCaps") : nbt.func_74775_l("Data"));
                }
                oldFile.delete();
            } else {
                NBTTagCompound nbt;
                File folder = new File(LMUtils.folderWorld, "data/ftb_lib/");
                MinecraftForge.EVENT_BUS.post((Event)new ForgeUniverseLoadedBeforePlayersEvent(this));
                HashMap<UUID, NBTTagCompound> playerNBT = new HashMap<UUID, NBTTagCompound>();
                HashMap<String, NBTTagCompound> teamNBT = new HashMap<String, NBTTagCompound>();
                File[] files = new File(folder, "players").listFiles();
                if (files != null && files.length > 0) {
                    for (File file : files) {
                        NBTTagCompound nbt2;
                        UUID uuid;
                        if (!file.getName().endsWith(".dat") || (uuid = LMStringUtils.fromString(LMFileUtils.getRawFileName(file))) == null || (nbt2 = LMNBTUtils.readTag(file)) == null) continue;
                        playerNBT.put(uuid, nbt2);
                        this.playerMap.put(uuid, new ForgePlayer(uuid, nbt2.func_74779_i("Name")));
                    }
                }
                if ((files = new File(folder, "teams").listFiles()) != null && files.length > 0) {
                    for (File file : files) {
                        NBTTagCompound nbt3;
                        if (!file.getName().endsWith(".dat") || (nbt3 = LMNBTUtils.readTag(file)) == null) continue;
                        String s = LMFileUtils.getRawFileName(file);
                        teamNBT.put(s, nbt3);
                        this.teams.put(s, new ForgeTeam(s));
                    }
                }
                for (IForgePlayer iForgePlayer : this.playerMap.values()) {
                    iForgePlayer.deserializeNBT((NBTBase)playerNBT.get(iForgePlayer.getId()));
                }
                for (IForgeTeam iForgeTeam : this.teams.values()) {
                    iForgeTeam.deserializeNBT((NBTBase)teamNBT.get(iForgeTeam.func_176610_l()));
                }
                MinecraftForge.EVENT_BUS.post((Event)new ForgeUniversePostLoadedEvent(this));
                if (this.dataStorage != null && (nbt = LMNBTUtils.readTag(new File(folder, "universe.dat"))) != null) {
                    this.dataStorage.deserializeNBT(nbt.func_74775_l("Data"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    @Nullable
    public INBTSerializable<?> getData(ResourceLocation id) {
        return this.dataStorage == null ? null : this.dataStorage.get(id);
    }

    @Override
    public Collection<? extends IForgePlayer> getPlayers() {
        return this.playerMap.values();
    }

    @Override
    @Nullable
    public ForgePlayer getPlayer(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof FakePlayer) {
            FakePlayer fp = (FakePlayer)o;
            ForgePlayerFake p = FAKE_PLAYER_MAP.get(fp.func_146103_bH().getId());
            if (p == null) {
                p = new ForgePlayerFake(fp);
                p.onLoggedIn((EntityPlayerMP)fp, false);
                FAKE_PLAYER_MAP.put(p.getId(), p);
            }
            return p;
        }
        if (o instanceof UUID) {
            UUID id = (UUID)o;
            if (id.getLeastSignificantBits() == 0L && id.getMostSignificantBits() == 0L) {
                return null;
            }
            return this.playerMap.get(id);
        }
        if (o instanceof IForgePlayer) {
            return this.getPlayer(((IForgePlayer)o).getId());
        }
        if (o instanceof EntityPlayer) {
            return this.getPlayer(((EntityPlayer)o).func_146103_bH().getId());
        }
        if (o instanceof GameProfile) {
            return this.getPlayer(((GameProfile)o).getId());
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s == null || s.isEmpty()) {
                return null;
            }
            for (ForgePlayer p : this.playerMap.values()) {
                if (!p.getName().equalsIgnoreCase(s)) continue;
                return p;
            }
            return this.getPlayer(LMStringUtils.fromString(s));
        }
        return null;
    }

    @Override
    public Collection<? extends IForgeTeam> getTeams() {
        return this.teams.values();
    }

    @Override
    @Nullable
    public ForgeTeam getTeam(String id) {
        return id.isEmpty() ? null : this.teams.get(id);
    }

    public void onClosed() {
        MinecraftForge.EVENT_BUS.post((Event)new ForgeUniverseClosedEvent(this));
        this.playerMap.clear();
    }

    @Override
    public Collection<IForgePlayer> getOnlinePlayers() {
        Set<IForgePlayer> l = Collections.emptySet();
        for (IForgePlayer iForgePlayer : this.playerMap.values()) {
            if (!iForgePlayer.isOnline()) continue;
            if (l.isEmpty()) {
                l = new HashSet<IForgePlayer>();
            }
            l.add(iForgePlayer);
        }
        return l;
    }

    public void save(File folder) throws Exception {
        for (ForgePlayer p : this.playerMap.values()) {
            NBTTagCompound nbt = p.serializeNBT();
            nbt.func_74778_a("Name", p.getName());
            LMNBTUtils.writeTag(new File(folder, "players/" + LMStringUtils.fromUUID(p.getId()) + ".dat"), nbt);
        }
        for (ForgeTeam team : this.teams.values()) {
            LMNBTUtils.writeTag(new File(folder, "teams/" + team.func_176610_l() + ".dat"), team.serializeNBT());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.dataStorage != null) {
            nbt.func_74782_a("Data", (NBTBase)this.dataStorage.serializeNBT());
        }
        LMNBTUtils.writeTag(new File(folder, "universe.dat"), nbt);
    }
}

