/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.api.IPackMode;
import com.feed_the_beast.ftbl.api.IPackModes;
import com.feed_the_beast.ftbl.api_impl.PackMode;
import com.feed_the_beast.ftbl.lib.util.LMFileUtils;
import com.feed_the_beast.ftbl.lib.util.LMJsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public enum PackModes implements IPackModes
{
    INSTANCE;

    private Map<String, IPackMode> modes;
    private IPackMode defaultMode;
    private Map<String, JsonElement> customData;

    public void load() {
        File file = LMFileUtils.newFile(new File(LMUtils.folderModpack, "packmodes.json"));
        JsonElement el = LMJsonUtils.fromJson(file);
        JsonObject o = this.isValid(el) ? el.getAsJsonObject() : this.createDefault();
        HashMap<String, PackMode> modes0 = new HashMap<String, PackMode>();
        JsonArray a = o.get("modes").getAsJsonArray();
        for (int i = 0; i < a.size(); ++i) {
            PackMode m = new PackMode(a.get(i).getAsString());
            modes0.put(m.func_176610_l(), m);
        }
        this.defaultMode = (IPackMode)modes0.get(o.get("default").getAsString());
        if (modes0.containsKey("common")) {
            throw new RuntimeException("FTBLib: 'common' can't be one of 'modes'!");
        }
        this.modes = Collections.unmodifiableMap(modes0);
        HashMap customData0 = new HashMap();
        if (o.has("custom")) {
            JsonObject o1 = o.get("custom").getAsJsonObject();
            for (Map.Entry e : o1.entrySet()) {
                customData0.put(e.getKey(), e.getValue());
            }
        }
        this.customData = Collections.unmodifiableMap(customData0);
        LMJsonUtils.toJson(file, (JsonElement)INSTANCE.toJsonObject());
    }

    private boolean isValid(JsonElement e) {
        if (!e.isJsonObject()) {
            return false;
        }
        JsonObject o = e.getAsJsonObject();
        return o.has("modes") && o.has("default");
    }

    private JsonObject createDefault() {
        JsonObject o = new JsonObject();
        JsonArray a = new JsonArray();
        a.add((JsonElement)new JsonPrimitive("default"));
        o.add("modes", (JsonElement)a);
        o.add("default", (JsonElement)new JsonPrimitive("default"));
        return o;
    }

    public JsonObject toJsonObject() {
        JsonObject o = new JsonObject();
        JsonArray a = new JsonArray();
        for (IPackMode m : this.modes.values()) {
            a.add((JsonElement)new JsonPrimitive(m.func_176610_l()));
        }
        o.add("modes", (JsonElement)a);
        o.add("default", (JsonElement)new JsonPrimitive(this.defaultMode.func_176610_l()));
        if (!this.customData.isEmpty()) {
            JsonObject o1 = new JsonObject();
            for (Map.Entry<String, JsonElement> e : this.customData.entrySet()) {
                o1.add(e.getKey(), e.getValue());
            }
            o.add("custom", (JsonElement)o1);
        }
        return o;
    }

    @Override
    public Collection<IPackMode> getModes() {
        return this.modes.values();
    }

    @Override
    @Nullable
    public IPackMode getRawMode(String id) {
        return id.isEmpty() ? null : this.modes.get(id);
    }

    @Override
    public IPackMode getMode(String id) {
        if (id.isEmpty()) {
            return this.defaultMode;
        }
        IPackMode m = this.modes.get(id);
        return m == null ? this.defaultMode : m;
    }

    @Override
    public IPackMode getDefault() {
        return this.defaultMode;
    }

    @Override
    public JsonElement getCustomData(String id) {
        JsonElement e = this.customData.get(id);
        return e == null ? JsonNull.INSTANCE : e;
    }
}

