/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.imaginarytime;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.blocks.TileBase;
import jotato.quantumflux.helpers.BlockHelpers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileImaginaryTime
extends TileBase
implements IEnergyReceiver,
ITickable {
    protected EnergyStorage localEnergyStorage = new EnergyStorage(1000, ConfigMan.imaginaryTime_chargeRate);

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.localEnergyStorage.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.localEnergyStorage.readFromNBT(energyTag);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getEnergyStored(null) >= ConfigMan.imaginaryTime_energyRequirement) {
            int x = this.func_174877_v().func_177958_n();
            int y = this.func_174877_v().func_177956_o();
            int z = this.func_174877_v().func_177952_p();
            int range = ConfigMan.imaginaryTime_range + 1;
            for (int x2 = x - range; x2 <= x + range; ++x2) {
                for (int z2 = z - range; z2 <= z + range; ++z2) {
                    for (int y2 = y - 2; y2 < y + 2; ++y2) {
                        BlockPos targetPos = BlockHelpers.getBlockPosFromXYZ(x2, y2, z2);
                        IBlockState targetBlockState = this.field_145850_b.func_180495_p(targetPos);
                        Block block = targetBlockState.func_177230_c();
                        if (block == null) continue;
                        block.func_180650_b(this.field_145850_b, targetPos, targetBlockState, this.field_145850_b.field_73012_v);
                        block = null;
                    }
                }
            }
            this.localEnergyStorage.extractEnergy(ConfigMan.imaginaryTime_energyRequirement, false);
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.localEnergyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.localEnergyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.localEnergyStorage.getMaxEnergyStored();
    }
}

