/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.entropyaccelerator;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.blocks.TileSimpleInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntropyAccelerator
extends TileSimpleInventory
implements IEnergyProvider,
ITickable {
    private int currentBurnTime = 0;
    private EnergyStorage energy;
    public int maxBurnTime = ConfigMan.incinerator_burnTime;
    public boolean isBurning = false;

    public TileEntropyAccelerator() {
        super(1, "");
        this.energy = new EnergyStorage(ConfigMan.incinerator_buffer, Integer.MAX_VALUE, ConfigMan.incinerator_output);
    }

    public boolean isActive() {
        return (this.hasFuel() || this.isBurning) && this.energy.getEnergyStored() < this.energy.getMaxEnergyStored();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74777_a("currentBurnTime", (short)this.currentBurnTime);
        NBTTagCompound fuelTag = new NBTTagCompound();
        tag.func_74782_a("Items", (NBTBase)fuelTag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energy.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74757_a("Burning", this.isBurning);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.currentBurnTime = tag.func_74765_d("currentBurnTime");
        this.energy.readFromNBT(energyTag);
        this.isBurning = tag.func_74767_n("Burning");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive()) {
                if (this.currentBurnTime == 0) {
                    this.isBurning = true;
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                }
                this.energy.receiveEnergy(ConfigMan.incinerator_output, false);
                ++this.currentBurnTime;
                if (this.currentBurnTime >= this.maxBurnTime) {
                    this.currentBurnTime = 0;
                    this.isBurning = false;
                }
                this.func_70296_d();
            }
            for (EnumFacing dir : EnumFacing.values()) {
                IEnergyReceiver receiver;
                BlockPos targetBlock = this.func_174877_v().func_177971_a(dir.func_176730_m());
                TileEntity tile = this.field_145850_b.func_175625_s(targetBlock);
                if (!(tile instanceof IEnergyReceiver) || !(receiver = (IEnergyReceiver)tile).canConnectEnergy(dir.func_176734_d())) continue;
                int tosend = this.energy.extractEnergy(ConfigMan.incinerator_output, true);
                int used = ((IEnergyReceiver)tile).receiveEnergy(dir.func_176734_d(), tosend, false);
                if (used > 0) {
                    this.func_70296_d();
                }
                this.energy.extractEnergy(used, false);
            }
        }
    }

    public void setEnergyStored(int value) {
        this.func_70296_d();
        this.energy.setEnergyStored(value);
    }

    private boolean hasFuel() {
        return this.inventory != null && this.inventory.length > 0 && this.inventory[0] != null && this.inventory[0].field_77994_a > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBufferScaled(int scale) {
        return this.getEnergyStored(null) * scale / this.getMaxEnergyStored(null);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int toget = this.energy.extractEnergy(maxExtract, simulate);
        if (toget > 0 && !simulate) {
            this.func_70296_d();
        }
        return toget;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }
}

