/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.cluster;

import cofh.api.energy.IEnergyContainerItem;
import jotato.quantumflux.helpers.NbtHelpers;
import jotato.quantumflux.machines.cluster.BlockQuibitCluster;
import jotato.quantumflux.machines.cluster.EnumQuibitCluster;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ItemBlockQuibitCluster
extends ItemBlock
implements IEnergyContainerItem {
    private static final String energy_tag = "Energy";

    public ItemBlockQuibitCluster(Block block) {
        super(block);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int func_77647_b(int metadata) {
        return metadata;
    }

    public String func_77667_c(ItemStack stack) {
        EnumQuibitCluster level = EnumQuibitCluster.byMetadata(stack.func_77960_j());
        return super.func_77658_a() + "." + level.toString();
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int toReceive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.getTransferRate(container)));
        if (!simulate) {
            NbtHelpers.setInt(container, energy_tag, stored += toReceive);
        }
        return toReceive;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int toExtract = Math.min(maxExtract, stored);
        if (!simulate) {
            NbtHelpers.setInt(container, energy_tag, stored -= toExtract);
        }
        return toExtract;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return NbtHelpers.getInt(container, energy_tag);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return BlockQuibitCluster.getQuibitClusterSettings((ItemStack)container).capacity;
    }

    public int getTransferRate(ItemStack container) {
        return BlockQuibitCluster.getQuibitClusterSettings((ItemStack)container).transferRate;
    }

    public void setEnergyStored(ItemStack container, int energy) {
        NbtHelpers.setInt(container, energy_tag, energy);
    }
}

