/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.itemsearch;

import at.feldim2425.moreoverlays.MoreOverlays;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.JEIPlugin;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.ItemListOverlayInternal;
import net.minecraft.client.gui.GuiTextField;

@JEIPlugin
public class JeiModule
extends BlankModPlugin {
    public static IItemListOverlay overlay;
    private static ItemListOverlayInternal overlayInternal;
    private static GuiTextField textField;

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        overlay = jeiRuntime.getItemListOverlay();
        JeiModule.updateModule();
    }

    public static void updateModule() {
        if (overlay instanceof ItemListOverlay && ((ItemListOverlay)overlay).getInternal() != null) {
            overlayInternal = ((ItemListOverlay)overlay).getInternal();
            try {
                Field searchField = ItemListOverlayInternal.class.getDeclaredField("searchField");
                searchField.setAccessible(true);
                textField = (GuiTextField)searchField.get(overlayInternal);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                MoreOverlays.logger.error("Something went wrong. Tried to load JEI Search Text Field object");
                e.printStackTrace();
            }
        } else {
            overlayInternal = null;
            textField = null;
        }
    }

    public static boolean hasJEIFocus() {
        return overlayInternal != null && overlayInternal.hasKeyboardFocus();
    }

    public static GuiTextField getJEITextField() {
        return textField;
    }
}

