/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.world.backups;

import com.feed_the_beast.ftbl.lib.BroadcastSender;
import com.feed_the_beast.ftbl.lib.math.MathHelperLM;
import com.feed_the_beast.ftbl.lib.util.LMFileUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.world.backups.Backup;
import com.feed_the_beast.ftbu.world.backups.Backups;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ThreadBackup
extends Thread {
    public boolean isDone = false;
    private final File src0;
    private final String customName;

    public ThreadBackup(File w, String s) {
        this.src0 = w;
        this.customName = s;
        this.setPriority(7);
    }

    public static void doBackup(File src, String customName) {
        StringBuilder out;
        boolean success;
        Calendar time;
        block15: {
            time = Calendar.getInstance();
            File dstFile = null;
            success = false;
            out = new StringBuilder();
            if (customName.isEmpty()) {
                ThreadBackup.appendNum(out, time.get(1), '-');
                ThreadBackup.appendNum(out, time.get(2) + 1, '-');
                ThreadBackup.appendNum(out, time.get(5), '-');
                ThreadBackup.appendNum(out, time.get(11), '-');
                ThreadBackup.appendNum(out, time.get(12), '-');
                ThreadBackup.appendNum(out, time.get(13), '\u0000');
            } else {
                out.append(customName);
            }
            try {
                List files = LMFileUtils.listAll((File)src);
                int allFiles = files.size();
                FTBUFinals.LOGGER.info("Backing up " + files.size() + " files...");
                if (FTBUConfigBackups.COMPRESSION_LEVEL.getInt() > 0) {
                    out.append(".zip");
                    dstFile = LMFileUtils.newFile((File)new File(Backups.INSTANCE.backupsFolder, out.toString()));
                    long start = System.currentTimeMillis();
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
                    zos.setLevel(FTBUConfigBackups.COMPRESSION_LEVEL.getInt());
                    long logMillis = System.currentTimeMillis() + 5000L;
                    byte[] buffer = new byte[4096];
                    FTBUFinals.LOGGER.info("Compressing " + allFiles + " files!");
                    for (int i = 0; i < allFiles; ++i) {
                        int len;
                        File file = (File)files.get(i);
                        String filePath = file.getAbsolutePath();
                        ZipEntry ze = new ZipEntry(src.getName() + File.separator + filePath.substring(src.getAbsolutePath().length() + 1, filePath.length()));
                        long millis = System.currentTimeMillis();
                        if (i == 0 || millis > logMillis || i == allFiles - 1) {
                            logMillis = millis + 5000L;
                            FTBUFinals.LOGGER.info("[" + i + " | " + MathHelperLM.toSmallDouble((double)((double)i / (double)allFiles * 100.0)) + "%]: " + ze.getName());
                        }
                        zos.putNextEntry(ze);
                        FileInputStream fis = new FileInputStream(file);
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        fis.close();
                    }
                    zos.close();
                    FTBUFinals.LOGGER.info("Done compressing in " + ThreadBackup.getDoneTime(start) + " seconds (" + LMFileUtils.getSizeS((File)dstFile) + ")!");
                } else {
                    out.append('/');
                    out.append(src.getName());
                    dstFile = new File(Backups.INSTANCE.backupsFolder, out.toString());
                    dstFile.mkdirs();
                    String dstPath = dstFile.getAbsolutePath() + File.separator;
                    String srcPath = src.getAbsolutePath();
                    long logMillis = System.currentTimeMillis() + 2000L;
                    for (int i = 0; i < allFiles; ++i) {
                        File file = (File)files.get(i);
                        long millis = System.currentTimeMillis();
                        if (i == 0 || millis > logMillis || i == allFiles - 1) {
                            logMillis = millis + 2000L;
                            FTBUFinals.LOGGER.info("[" + i + " | " + MathHelperLM.toSmallDouble((double)((double)i / (double)allFiles * 100.0)) + "%]: " + file.getName());
                        }
                        File dst1 = new File(dstPath + file.getAbsolutePath().replace(srcPath, ""));
                        LMFileUtils.copyFile((File)file, (File)dst1);
                    }
                }
                FTBUFinals.LOGGER.info("Created " + dstFile.getAbsolutePath() + " from " + src.getAbsolutePath());
                success = true;
                if (!FTBUConfigBackups.SILENT.getBoolean()) {
                    if (FTBUConfigBackups.DISPLAY_FILE_SIZE.getBoolean()) {
                        String sizeB = LMFileUtils.getSizeS((File)dstFile);
                        String sizeT = LMFileUtils.getSizeS((File)Backups.INSTANCE.backupsFolder);
                        ITextComponent c = FTBULang.BACKUP_END_2.textComponent(new Object[]{ThreadBackup.getDoneTime(time.getTimeInMillis()), sizeB.equals(sizeT) ? sizeB : sizeB + " | " + sizeT});
                        c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                        BroadcastSender.INSTANCE.func_145747_a(c);
                    } else {
                        ITextComponent c = FTBULang.BACKUP_END_1.textComponent(new Object[]{ThreadBackup.getDoneTime(time.getTimeInMillis())});
                        c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                        BroadcastSender.INSTANCE.func_145747_a(c);
                    }
                }
            }
            catch (Exception ex) {
                ITextComponent c = FTBULang.BACKUP_FAIL.textComponent(new Object[]{ex.getClass().getName()});
                c.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                if (!FTBUConfigBackups.SILENT.getBoolean()) {
                    BroadcastSender.INSTANCE.func_145747_a(c);
                }
                ex.printStackTrace();
                if (dstFile == null) break block15;
                LMFileUtils.delete(dstFile);
            }
        }
        Backups.INSTANCE.backups.add(new Backup(time.getTimeInMillis(), out.toString().replace('\\', '/'), Backups.INSTANCE.getLastIndex() + 1, success));
        Backups.INSTANCE.cleanupAndSave();
    }

    private static String getDoneTime(long l) {
        l = System.currentTimeMillis() - l;
        if (l < 1000L) {
            return l + "ms";
        }
        return LMStringUtils.getTimeString((long)l);
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    @Override
    public void run() {
        this.isDone = false;
        ThreadBackup.doBackup(this.src0, this.customName);
        this.isDone = true;
    }
}

