/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.ranks;

import com.feed_the_beast.ftbl.api.IRankConfig;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.FinalIDObject;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.api.IRank;
import com.feed_the_beast.ftbu.ranks.DefaultPlayerRank;
import com.feed_the_beast.ftbu.ranks.Ranks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.IJsonSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Rank
extends FinalIDObject
implements IRank,
IJsonSerializable {
    private static final String[] EVENT_RESULT_PREFIX = new String[]{"-", "~", "+"};
    IRank parent;
    private final Map<String, Event.Result> permissions = new LinkedHashMap<String, Event.Result>();
    private final Map<String, Event.Result> cachedPermissions = new HashMap<String, Event.Result>();
    private final Map<String, IConfigValue> config = new LinkedHashMap<String, IConfigValue>();
    private final Map<String, IConfigValue> cachedConfig = new HashMap<String, IConfigValue>();
    String syntax = null;

    public Rank(String id) {
        super(id);
    }

    @Override
    public IRank getParent() {
        return this.parent == null ? DefaultPlayerRank.INSTANCE : this.parent;
    }

    private Event.Result hasPermissionRaw(String permission) {
        Event.Result r = this.permissions.get(permission);
        if (r != null) {
            return r;
        }
        String[] splitPermission = permission.split("\\.");
        for (Map.Entry<String, Event.Result> entry : this.permissions.entrySet()) {
            if (!LMStringUtils.nodesMatch((String[])splitPermission, (String[])entry.getKey().split("\\."))) continue;
            return entry.getValue();
        }
        return this.getParent().hasPermission(permission);
    }

    @Override
    public Event.Result hasPermission(String permission) {
        Event.Result r = this.cachedPermissions.get(permission);
        if (r == null) {
            r = this.hasPermissionRaw(permission);
            this.cachedPermissions.put(permission, r);
        }
        return r;
    }

    @Override
    public IConfigValue getConfig(String id) {
        IConfigValue e = this.cachedConfig.get(id);
        if (e == null && ((e = this.config.get(id)) == null || e.isNull())) {
            e = this.getParent().getConfig(id);
        }
        this.cachedConfig.put(id, e);
        return e;
    }

    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        o.add("parent", (JsonElement)new JsonPrimitive(this.getParent().func_176610_l()));
        if (this.syntax != null) {
            o.add("syntax", (JsonElement)new JsonPrimitive(this.syntax.replace('\u00a7', '&')));
        }
        JsonArray a1 = new JsonArray();
        for (Map.Entry<String, Event.Result> e : this.permissions.entrySet()) {
            a1.add((JsonElement)new JsonPrimitive(EVENT_RESULT_PREFIX[e.getValue().ordinal()] + e.getKey()));
        }
        o.add("permissions", (JsonElement)a1);
        JsonObject o1 = new JsonObject();
        this.config.forEach((key, value) -> o1.add(key, value.func_151003_a()));
        o.add("config", (JsonElement)o1);
        return o;
    }

    public void func_152753_a(JsonElement e) {
        this.parent = null;
        this.permissions.clear();
        this.config.clear();
        this.cachedPermissions.clear();
        this.cachedConfig.clear();
        this.syntax = null;
        if (!e.isJsonObject()) {
            return;
        }
        JsonObject o = e.getAsJsonObject();
        if (o.has("parent")) {
            this.parent = Ranks.getRank(o.get("parent").getAsString(), null);
        }
        if (o.has("syntax")) {
            this.syntax = o.get("syntax").getAsString().replace('&', '\u00a7');
        }
        if (o.has("permissions")) {
            JsonArray a = o.get("permissions").getAsJsonArray();
            for (int i = 0; i < a.size(); ++i) {
                String key;
                String id = a.get(i).getAsString();
                char firstChar = id.charAt(0);
                String string = key = firstChar == '-' || firstChar == '+' || firstChar == '~' ? id.substring(1) : id;
                this.permissions.put(key, firstChar == '-' ? Event.Result.DENY : (firstChar == '~' ? Event.Result.DEFAULT : Event.Result.ALLOW));
            }
        }
        if (o.has("config")) {
            for (Map.Entry entry : o.get("config").getAsJsonObject().entrySet()) {
                IRankConfig rconfig = (IRankConfig)FTBLibIntegration.API.getRankConfigRegistry().get(entry.getKey());
                if (rconfig == null) continue;
                IConfigValue value = rconfig.getDefValue().copy();
                value.func_152753_a((JsonElement)entry.getValue());
                this.config.put(rconfig.func_176610_l(), value);
            }
        }
    }

    @Override
    public String getSyntax() {
        return this.syntax == null ? this.getParent().getSyntax() : this.syntax;
    }
}

