/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.recipe;

import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class RecipeInputFluidContainer
implements IRecipeInput {
    public final Fluid fluid;
    public final int amount;

    public RecipeInputFluidContainer(Fluid fluid) {
        this(fluid, 1000);
    }

    public RecipeInputFluidContainer(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    @Override
    public boolean matches(ItemStack subject) {
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)subject);
        if (fs == null && subject.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem item = (IFluidContainerItem)subject.func_77973_b();
            fs = item.getFluid(subject);
        }
        return fs == null && this.fluid == null || fs != null && fs.getFluid() == this.fluid && fs.amount >= this.amount;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (data.fluid.getFluid() != this.fluid) continue;
            ret.add(RecipeUtil.setImmutableSize(data.filledContainer, this.getAmount()));
        }
        ret.add(RecipeUtil.setImmutableSize(IC2Items.getItem("fluid_cell", this.fluid.getName()), this.getAmount()));
        return Collections.unmodifiableList(ret);
    }

    public String toString() {
        return "RInputFluidContainer<" + this.amount + "x" + this.fluid.getName() + ">";
    }
}

