/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.climate.EnumClimatiserModes;
import forestry.api.climate.EnumClimatiserTypes;
import forestry.api.climate.IClimatiserDefinition;
import forestry.core.climate.ClimatiserDefinition;
import forestry.greenhouse.GreenhouseClimateWindow;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.tiles.TileGreenhouseClimatiser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileGreenhouseWindow
extends TileGreenhouseClimatiser {
    private WindowMode mode;

    public TileGreenhouseWindow() {
        super((IClimatiserDefinition)new ClimatiserDefinition(0.001f, EnumClimatiserModes.NONE, 5.0, EnumClimatiserTypes.NONE), new GreenhouseClimateWindow(20));
    }

    public void onNeighborBlockChange() {
        WindowMode otherMode = this.isBlocked();
        if (this.getMode() != WindowMode.PLAYER && this.getMode() != WindowMode.CONTROL && otherMode != this.getMode()) {
            this.setMode(otherMode);
        }
    }

    public WindowMode isBlocked() {
        if (this.field_145850_b == null) {
            return WindowMode.BLOCK;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state == null) {
            return WindowMode.BLOCK;
        }
        BlockPos blockedPos = state.func_177230_c() == PluginGreenhouse.blocks.getGreenhouseBlock(BlockGreenhouseType.WINDOW_UP) ? this.getCoordinates().func_177972_a(EnumFacing.UP) : this.getCoordinates().func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockGreenhouse.FACING));
        return this.field_145850_b.func_175623_d(blockedPos) ? WindowMode.OPEN : WindowMode.BLOCK;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        if (this.mode != null) {
            data.func_74777_a("mode", (short)this.mode.ordinal());
        }
        return super.func_189515_b(data);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("mode")) {
            this.setMode(WindowMode.values()[data.func_74765_d("mode")]);
        }
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        if (packetData.func_74764_b("mode")) {
            this.setMode(WindowMode.values()[packetData.func_74765_d("mode")]);
        }
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        if (this.mode != null) {
            packetData.func_74777_a("mode", (short)this.mode.ordinal());
        }
        super.encodeDescriptionPacket(packetData);
    }

    @Override
    public boolean canWork() {
        return true;
    }

    public void setMode(WindowMode mode) {
        this.mode = mode;
        this.setActive(mode == WindowMode.OPEN);
    }

    public WindowMode getMode() {
        return this.mode;
    }

    public static enum WindowMode {
        PLAYER,
        BLOCK,
        CONTROL,
        OPEN;

    }
}

