/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.greenhouse.IGreenhouseHelper;
import forestry.api.greenhouse.IGreenhouseLogic;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.InternalBlockCheck;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GreenhouseHelper
implements IGreenhouseHelper {
    private final List<Class<? extends IGreenhouseLogic>> greenhouseLogics = new ArrayList<Class<? extends IGreenhouseLogic>>();

    @Override
    public IGreenhouseController getGreenhouseController(World world, BlockPos pos) {
        if (MultiblockRegistry.getControllersFromWorld(world) != null) {
            for (IMultiblockControllerInternal controllerInternal : MultiblockRegistry.getControllersFromWorld(world)) {
                if (!(controllerInternal instanceof IGreenhouseControllerInternal) || !controllerInternal.isAssembled() || !GreenhouseHelper.isPositionInGreenhouse((IGreenhouseControllerInternal)controllerInternal, pos)) continue;
                return (IGreenhouseController)((Object)controllerInternal);
            }
        }
        return null;
    }

    private static boolean isPositionInGreenhouse(IGreenhouseControllerInternal controller, BlockPos pos) {
        InternalBlockCheck checkBlock = new InternalBlockCheck(pos);
        return controller.getInternalBlocks().contains(checkBlock);
    }

    @Override
    public void addGreenhouseLogic(Class<? extends IGreenhouseLogic> logic) {
        if (!this.greenhouseLogics.contains(logic)) {
            this.greenhouseLogics.add(logic);
        }
    }

    @Override
    public List<Class<? extends IGreenhouseLogic>> getGreenhouseLogics() {
        return this.greenhouseLogics;
    }
}

