/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.tiles.IClimatised;
import forestry.farming.gui.IFarmLedgerDelegate;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmHydrationManager
implements IFarmLedgerDelegate,
INbtWritable,
INbtReadable,
IStreamable {
    private static final int DELAY_HYDRATION = 100;
    private static final float RAINFALL_MODIFIER_MAX = 15.0f;
    private static final float RAINFALL_MODIFIER_MIN = 0.5f;
    @Nonnull
    private final IClimatised climatised;
    private int hydrationDelay = 0;
    private int ticksSinceRainfall = 0;

    public FarmHydrationManager(@Nonnull IClimatised climatised) {
        this.climatised = climatised;
    }

    public void updateServer(World world, BlockPos coordinates) {
        if (world.func_175727_C(coordinates.func_177984_a())) {
            if (this.hydrationDelay > 0) {
                --this.hydrationDelay;
            } else {
                this.ticksSinceRainfall = 0;
            }
        } else {
            this.hydrationDelay = 100;
            if (this.ticksSinceRainfall < Integer.MAX_VALUE) {
                ++this.ticksSinceRainfall;
            }
        }
    }

    @Override
    public float getHydrationModifier() {
        return this.getHydrationTempModifier() * this.getHydrationHumidModifier() * this.getHydrationRainfallModifier();
    }

    @Override
    public float getHydrationTempModifier() {
        float temperature = this.climatised.getExactTemperature();
        return temperature > 0.8f ? temperature : 0.8f;
    }

    @Override
    public float getHydrationHumidModifier() {
        float mod = 1.0f / this.climatised.getExactHumidity();
        return mod < 2.0f ? mod : 2.0f;
    }

    @Override
    public float getHydrationRainfallModifier() {
        float mod = (float)this.ticksSinceRainfall / 24000.0f;
        if (mod <= 0.5f) {
            return 0.5f;
        }
        if (mod >= 15.0f) {
            return 15.0f;
        }
        return mod;
    }

    @Override
    public double getDrought() {
        return (double)Math.round((double)this.ticksSinceRainfall / 24000.0 * 10.0) / 10.0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("HydrationDelay", this.hydrationDelay);
        nbttagcompound.func_74768_a("TicksSinceRainfall", this.ticksSinceRainfall);
        return nbttagcompound;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.hydrationDelay);
        data.writeVarInt(this.ticksSinceRainfall);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.hydrationDelay = data.readVarInt();
        this.ticksSinceRainfall = data.readVarInt();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.hydrationDelay = nbt.func_74762_e("HydrationDelay");
        this.ticksSinceRainfall = nbt.func_74762_e("TicksSinceRainfall");
    }
}

