/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.farming.multiblock.InventoryFarm;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class FarmFertilizerManager
implements INbtWritable,
INbtReadable,
IStreamable {
    private static final int BUFFER_FERTILIZER = 200;
    private int storedFertilizer = 0;

    public boolean hasFertilizer(InventoryFarm inventory, int amount) {
        if (inventory.getFertilizerValue() < 0) {
            return true;
        }
        return this.storedFertilizer >= amount;
    }

    public void removeFertilizer(InventoryFarm inventory, int amount) {
        if (inventory.getFertilizerValue() < 0) {
            return;
        }
        this.storedFertilizer -= amount;
        if (this.storedFertilizer < 0) {
            this.storedFertilizer = 0;
        }
    }

    public boolean maintainFertilizer(InventoryFarm inventory) {
        if (this.storedFertilizer <= 200) {
            int fertilizerValue = inventory.getFertilizerValue();
            if (fertilizerValue < 0) {
                this.storedFertilizer += 2000;
            } else if (inventory.useFertilizer()) {
                this.storedFertilizer += fertilizerValue;
            }
        }
        return this.storedFertilizer > 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.storedFertilizer = data.func_74762_e("StoredFertilizer");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("StoredFertilizer", this.storedFertilizer);
        return data;
    }

    public int getStoredFertilizerScaled(InventoryFarm inventory, int scale) {
        if (this.storedFertilizer == 0) {
            return 0;
        }
        return this.storedFertilizer * scale / (inventory.getFertilizerValue() + 200);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.storedFertilizer);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.storedFertilizer = data.readVarInt();
    }
}

