/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicWatered;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FarmLogicCrops
extends FarmLogicWatered {
    private final Iterable<IFarmable> seeds;

    protected FarmLogicCrops(Iterable<IFarmable> seeds) {
        super(new ItemStack(Blocks.field_150346_d), Blocks.field_150458_ak.func_176223_P());
        this.seeds = seeds;
    }

    @Override
    public boolean isAcceptedGround(@Nonnull IBlockState blockState) {
        return super.isAcceptedGround(blockState) || blockState.func_177230_c() == Blocks.field_150458_ak;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> collect(World world, IFarmHousing farmHousing) {
        List products = this.produce;
        this.produce = this.collectEntityItems(world, farmHousing, false);
        return products;
    }

    @Override
    protected boolean maintainCrops(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            IBlockState groundState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isAcceptedGround(groundState = world.func_180495_p(position.func_177977_b()))) continue;
            return this.trySetCrop(world, farmHousing, position);
        }
        return false;
    }

    private boolean trySetCrop(World world, IFarmHousing farmHousing, BlockPos position) {
        for (IFarmable candidate : this.seeds) {
            if (!farmHousing.plantGermling(candidate, world, position)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        Stack<ICrop> crops = new Stack<ICrop>();
        block0: for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, i);
            IBlockState blockState = world.func_180495_p(position);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position, blockState);
                if (crop == null) continue;
                crops.push(crop);
                continue block0;
            }
        }
        return crops;
    }
}

