/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.CropDestroy;
import forestry.plugins.compat.PluginIC2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CropRubber
extends CropDestroy {
    public CropRubber(World world, IBlockState blockState, BlockPos position) {
        super(world, blockState, position, CropRubber.getReplantState(blockState));
    }

    private static <T extends Comparable<T>> IBlockState getReplantState(IBlockState sappyState) {
        if (CropRubber.hasRubberToHarvest(sappyState)) {
            for (Map.Entry wetPropertyEntry : sappyState.func_177228_b().entrySet()) {
                String valueWetString = ((Comparable)wetPropertyEntry.getValue()).toString();
                String valueDryString = valueWetString.replace("wet", "dry");
                IProperty property = (IProperty)wetPropertyEntry.getKey();
                IBlockState baseState = sappyState.func_177230_c().func_176194_O().func_177621_b();
                IBlockState dryState = CropRubber.getStateWithValue(baseState, property, valueDryString);
                if (dryState == null) continue;
                return dryState;
            }
        }
        return sappyState.func_177230_c().func_176223_P();
    }

    public static boolean hasRubberToHarvest(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (ItemStackUtil.equals(block, PluginIC2.rubberWood)) {
            ImmutableCollection propertyValues = blockState.func_177228_b().values();
            for (Comparable propertyValue : propertyValues) {
                if (!propertyValue.toString().contains("wet")) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static <T extends Comparable<T>> IBlockState getStateWithValue(IBlockState baseState, IProperty<T> property, String valueString) {
        Optional value = property.func_185929_b(valueString);
        if (value.isPresent()) {
            return baseState.func_177226_a(property, (Comparable)value.get());
        }
        return null;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(World world, BlockPos pos) {
        ArrayList<ItemStack> harvested = new ArrayList<ItemStack>();
        harvested.add(PluginIC2.resin.func_77946_l());
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, this.blockState);
        Proxies.net.sendNetworkPacket(packet, world);
        world.func_180501_a(pos, this.replantState, 2);
        return harvested;
    }
}

