/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileMill;
import forestry.factory.inventory.InventoryRainmaker;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;

public class TileMillRainmaker
extends TileMill {
    private int duration;
    private boolean reverse;

    public TileMillRainmaker() {
        super(null);
        this.speed = 0.01f;
        this.setInternalInventory(new InventoryRainmaker(this));
    }

    @Override
    public void openGui(EntityPlayer player, ItemStack heldItem) {
        RainSubstrate substrate;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (heldItem == null) {
            return;
        }
        if (FuelManager.rainSubstrate.containsKey(heldItem) && this.charge == 0 && (substrate = FuelManager.rainSubstrate.get(heldItem)).getItem().func_77969_a(heldItem)) {
            this.addCharge(substrate);
            --heldItem.field_77994_a;
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.charge = nbttagcompound.func_74762_e("Charge");
        this.progress = nbttagcompound.func_74760_g("Progress");
        this.stage = nbttagcompound.func_74762_e("Stage");
        this.duration = nbttagcompound.func_74762_e("Duration");
        this.reverse = nbttagcompound.func_74767_n("Reverse");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Charge", this.charge);
        nbttagcompound.func_74776_a("Progress", this.progress);
        nbttagcompound.func_74768_a("Stage", this.stage);
        nbttagcompound.func_74768_a("Duration", this.duration);
        nbttagcompound.func_74757_a("Reverse", this.reverse);
        return nbttagcompound;
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.getSpeed();
        this.duration = substrate.getDuration();
        this.reverse = substrate.isReverse();
        this.sendNetworkUpdate();
    }

    @Override
    public void activate() {
        if (Proxies.render.hasRendering()) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
            float f = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float f1 = (float)this.func_174877_v().func_177956_o() + 0.0f + this.field_145850_b.field_73012_v.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f;
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f - f3, f1, f2 + f4);
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f + f3, f1, f2 + f4);
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f + f4, f1, f2 - f3);
            Proxies.render.addEntityExplodeFX(this.field_145850_b, f + f4, f1, f2 + f3);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.reverse) {
                this.field_145850_b.func_72912_H().func_76084_b(false);
            } else {
                this.field_145850_b.func_72912_H().func_76084_b(true);
                this.field_145850_b.func_72912_H().func_76080_g(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.sendNetworkUpdate();
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return null;
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return null;
    }
}

