/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.compat.tesla;

import forestry.core.utils.Log;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Optional;

public class TeslaHelper {
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<ITeslaConsumer> TESLA_CONSUMER = null;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<ITeslaProducer> TESLA_PRODUCER = null;
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<ITeslaHolder> TESLA_HOLDER = null;

    public static boolean isLoaded() {
        return TESLA_CONSUMER != null && TESLA_PRODUCER != null && TESLA_HOLDER != null;
    }

    public static boolean isEnergyReceiver(TileEntity tile, EnumFacing side) {
        if (TeslaHelper.isLoaded()) {
            return TeslaHelper._isEnergyReceiver(tile, side);
        }
        return false;
    }

    public static int sendEnergy(TileEntity tile, EnumFacing side, int amount, boolean simulate) {
        if (TeslaHelper.isLoaded()) {
            return TeslaHelper._sendEnergy(tile, side, amount, simulate);
        }
        return 0;
    }

    @Optional.Method(modid="tesla")
    private static boolean _isEnergyReceiver(TileEntity tile, EnumFacing side) {
        return TESLA_CONSUMER != null && tile.hasCapability(TESLA_CONSUMER, side);
    }

    @Optional.Method(modid="tesla")
    private static int _sendEnergy(TileEntity tile, EnumFacing side, int amount, boolean simulate) {
        ITeslaConsumer consumer = (ITeslaConsumer)tile.getCapability(TESLA_CONSUMER, side);
        if (consumer == null) {
            if (tile.hasCapability(TESLA_CONSUMER, side)) {
                Log.error("Tile claims to support Tesla but does not have the capability. {} {}", tile.func_174877_v(), tile);
            }
            return 0;
        }
        return (int)consumer.givePower((long)amount, simulate);
    }
}

