/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class Stack {
    private final String name;
    private final int meta;

    public Stack(String name, int meta) {
        this.name = name;
        this.meta = meta;
    }

    public static List<Stack> parseStackStrings(String itemStackStrings, int missingMetaValue) {
        String[] parts = itemStackStrings.split("(\\s*;\\s*)+");
        return Stack.parseStackStrings(parts, missingMetaValue);
    }

    public static List<Stack> parseStackStrings(String[] parts, int missingMetaValue) {
        ArrayList<Stack> stacks = new ArrayList<Stack>();
        for (String itemStackString : parts) {
            Stack stack = Stack.parseStackString(itemStackString, missingMetaValue);
            if (stack == null) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static Stack parseStackString(String stackString, int missingMetaValue) {
        int meta;
        if (stackString == null) {
            return null;
        }
        if ((stackString = stackString.trim()).isEmpty()) {
            return null;
        }
        String[] parts = stackString.split(":+");
        if (parts.length != 2 && parts.length != 3) {
            Log.warning("Stack string (" + stackString + ") isn't formatted properly. Suitable formats are <modId>:<name>, <modId>:<name>:<meta> or <modId>:<name>:*, e.g. IC2:blockWall:*", new Object[0]);
            return null;
        }
        String name = parts[0] + ':' + parts[1];
        if (parts.length == 2) {
            meta = missingMetaValue;
        } else {
            try {
                meta = parts[2].equals("*") ? Short.MAX_VALUE : NumberFormat.getIntegerInstance().parse(parts[2]).intValue();
            }
            catch (ParseException e) {
                Log.warning("ItemStack string (" + stackString + ") has improperly formatted metadata. Suitable metadata are integer values or *.", new Object[0]);
                return null;
            }
        }
        return new Stack(name, meta);
    }

    public Item getItem() {
        Item item = ItemStackUtil.getItemFromRegistry(this.name);
        if (item == null) {
            Log.warning("Failed to find item for (" + this.name + ") in the Forge registry.", new Object[0]);
        }
        return item;
    }

    public Block getBlock() {
        Block block = ItemStackUtil.getBlockFromRegistry(this.name);
        if (block == null) {
            Log.warning("Failed to find block for (" + this.name + ") in the Forge registry.", new Object[0]);
        }
        return block;
    }

    public int getMeta() {
        return this.meta;
    }
}

