/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.blocks.BlockBase;
import forestry.core.config.Config;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IHintSource;
import forestry.core.tiles.TileForestry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileBase
extends TileForestry
implements IHintSource {
    protected final List<String> hints;

    protected TileBase(String hintKey) {
        this.hints = new ArrayList<String>(Config.hints.get((Object)hintKey));
    }

    public void openGui(EntityPlayer player, ItemStack heldItem) {
        GuiHandler.openGui(player, this);
    }

    public boolean canDrainWithBucket() {
        return false;
    }

    @Override
    public final List<String> getHints() {
        return this.hints;
    }

    @Override
    public String getUnlocalizedTitle() {
        Block block = this.func_145838_q();
        if (block instanceof BlockBase) {
            return block.func_149739_a() + ".name";
        }
        return super.getUnlocalizedTitle();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        Block newBlock;
        Block oldBlock = oldState.func_177230_c();
        return oldBlock != (newBlock = newState.func_177230_c()) || !(oldBlock instanceof BlockBase) || !(newBlock instanceof BlockBase);
    }
}

