/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import forestry.core.items.ItemCrated;
import forestry.core.models.BlankModel;
import forestry.core.models.TRSRBakedModel;
import forestry.storage.PluginStorage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelCrate
extends BlankModel {
    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms;
    private static Map<String, IBakedModel> cache;

    public static void onModelBake(ModelBakeEvent event) {
        cache.clear();
        itemTransforms = ModelCrate.getMap(new ResourceLocation("minecraft:models/item/generated"));
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getMap(ResourceLocation par1) {
        return IPerspectiveAwareModel.MapWrapper.getTransforms((ItemCameraTransforms)ModelCrate.getTransformFromJson(par1));
    }

    private static Reader getReaderForResource(ResourceLocation location) throws IOException {
        ResourceLocation file = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
        return new BufferedReader(new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8));
    }

    private static ItemCameraTransforms getTransformFromJson(ResourceLocation par1) {
        try {
            return ModelBlock.func_178307_a((Reader)ModelCrate.getReaderForResource(par1)).func_181682_g();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemCameraTransforms.field_178357_a;
        }
    }

    private IBakedModel getModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    @Override
    public ItemOverrideList createOverrides() {
        return new CrateOverrideList();
    }

    private List<IBakedModel> bakeModel(ItemCrated crateItem) {
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        ItemStack contained = crateItem.getContained();
        if (contained != null) {
            IBakedModel containedModel = this.getModel(contained);
            models.add(new TRSRBakedModel(containedModel, -0.0625f, 0.0f, 0.0625f, 0.5f));
            models.add(new TRSRBakedModel(containedModel, -0.0625f, 0.0f, -0.0625f, 0.5f));
        }
        return models;
    }

    @Override
    public boolean func_177556_c() {
        return false;
    }

    static {
        cache = new HashMap<String, IBakedModel>();
    }

    public static class BakedCrateModel
    extends BlankModel
    implements IPerspectiveAwareModel {
        BakedCrateModel other;
        boolean gui;
        List<BakedQuad> quads = new ArrayList<BakedQuad>();
        private List<BakedQuad> emptyList = new ArrayList<BakedQuad>();

        public BakedCrateModel(BakedCrateModel noneGui) {
            this.gui = true;
            this.other = noneGui;
            for (BakedQuad quad : this.other.quads) {
                if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                this.quads.add(quad);
            }
        }

        public BakedCrateModel(List<BakedQuad> data) {
            this.quads.addAll(data);
            this.gui = false;
            this.other = new BakedCrateModel(this);
        }

        @Override
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return side == null ? this.quads : this.emptyList;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair = IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)itemTransforms, (ItemCameraTransforms.TransformType)cameraTransformType);
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI && !this.gui && pair.getRight() == null) {
                return Pair.of((Object)this.other, null);
            }
            if (cameraTransformType != ItemCameraTransforms.TransformType.GUI && this.gui) {
                return Pair.of((Object)this.other, (Object)pair.getRight());
            }
            return pair;
        }
    }

    private class CrateOverrideList
    extends ItemOverrideList {
        public CrateOverrideList() {
            super(new ArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemCrated crated = (ItemCrated)stack.func_77973_b();
            String crateUID = crated.getUID();
            if (crateUID != null) {
                IBakedModel model = (IBakedModel)cache.get(crateUID);
                if (model == null) {
                    LinkedList<BakedQuad> list = new LinkedList<BakedQuad>();
                    IBakedModel baseBaked = ModelCrate.this.getModel(new ItemStack((Item)PluginStorage.items.crate, 1, 1));
                    for (BakedQuad quad : ForgeHooksClient.handleCameraTransforms((IBakedModel)baseBaked, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false).func_188616_a(null, null, 0L)) {
                        list.add(new BakedQuad(quad.func_178209_a(), 100, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
                    }
                    List textures = ModelCrate.this.bakeModel(crated);
                    for (IBakedModel bakybake : textures) {
                        list.addAll(ForgeHooksClient.handleCameraTransforms((IBakedModel)bakybake, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false).func_188616_a(null, null, 0L));
                    }
                    model = new BakedCrateModel(list);
                    cache.put(crateUID, model);
                }
                return model;
            }
            return originalModel;
        }
    }
}

