/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Function;
import forestry.core.inventory.ItemInventoryCamouflageSprayCan;
import forestry.core.models.BlankModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.models.ModelManager;
import forestry.core.models.TRSRBakedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelCamouflageSprayCan
extends BlankModel {
    @Override
    protected ItemOverrideList createOverrides() {
        return new SprayCanOverrideList();
    }

    private class SprayCanModel
    extends BlankModel
    implements IPerspectiveAwareModel {
        private final IBakedModel originalModel;
        private final IBakedModel camouflageModel;
        private final IModelState state;
        private final IBakedModel filledModel;

        public SprayCanModel(IBakedModel originalModel, IBakedModel filledModel, IBakedModel camouflageModel, IModelState state) {
            this.originalModel = originalModel;
            this.filledModel = filledModel;
            this.camouflageModel = camouflageModel;
            this.state = state;
        }

        @Override
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(this.filledModel.func_188616_a(state, side, rand));
            if (this.camouflageModel != null) {
                quads.addAll(this.camouflageModel.func_188616_a(state, side, rand));
            }
            return quads;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.state, (ItemCameraTransforms.TransformType)cameraTransformType);
            }
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this.originalModel, (IModelState)this.state, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }

    private class SprayCanOverrideList
    extends ItemOverrideList {
        public SprayCanOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemInventoryCamouflageSprayCan inventory;
            ItemStack camouflage;
            IModel basicModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("forestry:item/camouflageSprayCan"));
            IBakedModel model = basicModel.bake(basicModel.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new DefaultTextureGetter());
            IBakedModel filledModel = basicModel.bake(basicModel.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new DefaultTextureGetter());
            TRSRBakedModel camouflageModel = null;
            if (stack.func_77942_o() && entity instanceof EntityPlayer && (camouflage = (inventory = new ItemInventoryCamouflageSprayCan((EntityPlayer)entity, stack)).func_70301_a(0)) != null) {
                IModel filledBasicModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("forestry:item/camouflageSprayCanFilled"));
                filledModel = filledBasicModel.bake(filledBasicModel.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new DefaultTextureGetter());
                camouflageModel = new TRSRBakedModel(Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(camouflage), -0.1875f, 0.1875f, 0.0625f, 0.5f);
            }
            return new SprayCanModel(model, filledModel, camouflageModel, ModelManager.getInstance().DEFAULT_ITEM);
        }
    }
}

