/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import forestry.api.core.IModelBaker;
import forestry.api.core.IModelBakerModel;
import forestry.core.blocks.propertys.UnlistedBlockAccess;
import forestry.core.blocks.propertys.UnlistedBlockPos;
import forestry.core.models.baker.ModelBaker;
import forestry.core.proxy.Proxies;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class ModelBlockDefault<B extends Block, K>
implements IBakedModel {
    private ItemOverrideList overrideList;
    @Nonnull
    protected final Class<B> blockClass;
    protected IModelBakerModel blockModel;
    protected IModelBakerModel itemModel;

    protected ModelBlockDefault(@Nonnull Class<B> blockClass) {
        this.blockClass = blockClass;
    }

    @Nullable
    protected IBakedModel bakeModel(@Nonnull IBlockState state, @Nonnull K key) {
        if (key == null) {
            return null;
        }
        ModelBaker baker = new ModelBaker();
        Block block = state.func_177230_c();
        if (!this.blockClass.isInstance(block)) {
            return null;
        }
        Block bBlock = (Block)this.blockClass.cast(block);
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
            BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
            baker.setRenderBounds(state.func_185900_c(world, pos));
        }
        this.bakeBlock(bBlock, key, baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    protected IBakedModel getModel(IBlockState state) {
        return this.bakeModel(state, this.getWorldKey(state));
    }

    protected IBakedModel bakeModel(ItemStack stack, World world, K key) {
        if (key == null) {
            return null;
        }
        ModelBaker baker = new ModelBaker();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (!this.blockClass.isInstance(block)) {
            return null;
        }
        Block bBlock = (Block)this.blockClass.cast(block);
        IBlockState state = block.func_176203_a(stack.func_77952_i());
        baker.setRenderBounds(state.func_185900_c((IBlockAccess)world, null));
        this.bakeBlock(bBlock, key, baker, true);
        this.itemModel = baker.bakeModel(true);
        return this.itemModel;
    }

    protected IBakedModel getModel(ItemStack stack, World world) {
        if (stack == null) {
            return null;
        }
        return this.bakeModel(stack, world, this.getInventoryKey(stack));
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IBakedModel model = this.getModel(state);
        if (model != null) {
            return model.func_188616_a(state, side, rand);
        }
        return Collections.emptyList();
    }

    protected void onCreateModel(IModelBakerModel model) {
        model.setAmbientOcclusion(true);
    }

    public boolean func_177555_b() {
        if (this.itemModel == null && this.blockModel == null) {
            return false;
        }
        return this.blockModel != null ? this.blockModel.func_177555_b() : this.itemModel.func_177555_b();
    }

    public boolean func_177556_c() {
        if (this.itemModel == null) {
            return false;
        }
        return this.itemModel.func_177556_c();
    }

    public boolean func_188618_c() {
        if (this.itemModel == null && this.blockModel == null) {
            return false;
        }
        return this.blockModel != null ? this.blockModel.func_188618_c() : this.itemModel.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        if (this.blockModel != null) {
            return this.blockModel.func_177554_e();
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        if (this.itemModel == null) {
            return ItemCameraTransforms.field_178357_a;
        }
        return this.itemModel.func_177552_f();
    }

    protected ItemOverrideList createOverrides() {
        return new DefaultItemOverrideList();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        if (this.overrideList == null) {
            this.overrideList = this.createOverrides();
        }
        return this.overrideList;
    }

    protected abstract K getInventoryKey(@Nonnull ItemStack var1);

    protected abstract K getWorldKey(@Nonnull IBlockState var1);

    protected abstract void bakeBlock(@Nonnull B var1, @Nonnull K var2, @Nonnull IModelBaker var3, boolean var4);

    private class DefaultItemOverrideList
    extends ItemOverrideList {
        public DefaultItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (world == null) {
                world = Proxies.common.getRenderWorld();
            }
            return ModelBlockDefault.this.getModel(stack, world);
        }
    }
}

