/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.models.WoodTexture;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WoodTextureManager {
    protected static final Map<String, WoodTexture> WOOD_TEXTURES = new HashMap<String, WoodTexture>();
    public static final String KIND_KEY = "kind";
    public static final ResourceLocation LOCATION = new ResourceLocation("forestry:textures/woodTextures.json");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFile(IResourceManager resourceManager) {
        block9: {
            try {
                InputStream stream = resourceManager.func_110536_a(LOCATION).func_110527_b();
                try (JsonReader reader = null;){
                    reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(stream)));
                    JsonElement json = Streams.parse((JsonReader)reader);
                    if (json.isJsonObject()) {
                        JsonObject jsonObject = json.getAsJsonObject();
                        for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                            JsonElement element = (JsonElement)jsonEntry.getValue();
                            if (element.isJsonObject()) {
                                WoodTextureManager.addSingleTexture((String)jsonEntry.getKey(), element.getAsJsonObject());
                                continue;
                            }
                            if (!element.isJsonArray()) continue;
                            WoodTextureManager.addTextureMap((String)jsonEntry.getKey(), element.getAsJsonArray());
                        }
                    }
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block9;
                e.printStackTrace();
            }
        }
    }

    private static void addSingleTexture(String key, JsonObject object) {
        WOOD_TEXTURES.put(key, WoodTextureManager.createSimpleTexture(object));
    }

    private static void addTextureMap(String key, JsonArray jaonArray) {
        ImmutableMap.Builder textures = new ImmutableMap.Builder();
        for (JsonElement elementEntry : jaonArray) {
            JsonObject obj;
            String kind;
            if (!elementEntry.isJsonObject() || (kind = WoodTextureManager.getKind(obj = elementEntry.getAsJsonObject())) == null) continue;
            textures.put((Object)kind, (Object)WoodTextureManager.createSimpleTexture(obj));
        }
        WOOD_TEXTURES.put(key, new WoodTexture.TextureMap((ImmutableMap<String, WoodTexture.SimpleTexture>)textures.build()));
    }

    @Nullable
    private static String getKind(JsonObject obj) {
        if (!obj.has(KIND_KEY)) {
            return null;
        }
        JsonElement element = obj.get(KIND_KEY);
        if (!element.isJsonPrimitive()) {
            return null;
        }
        JsonPrimitive primative = element.getAsJsonPrimitive();
        if (!primative.isString()) {
            return null;
        }
        return primative.getAsString();
    }

    private static WoodTexture.SimpleTexture createSimpleTexture(JsonObject obj) {
        ImmutableMap.Builder locations = new ImmutableMap.Builder();
        for (Map.Entry entry : obj.entrySet()) {
            JsonPrimitive primitive;
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonPrimitive() || !(primitive = element.getAsJsonPrimitive()).isString()) continue;
            locations.put(entry.getKey(), (Object)primitive.getAsString());
        }
        return new WoodTexture.SimpleTexture((ImmutableMap<String, String>)locations.build());
    }

    private static WoodTexture getKindTexture(WoodBlockKind blockKind) {
        String kindName = blockKind.toString();
        return WOOD_TEXTURES.get(kindName);
    }

    private static WoodTexture getTexture(IWoodType woodType) {
        String woodName = woodType.func_176610_l();
        woodName = woodName.toLowerCase(Locale.ENGLISH);
        return WOOD_TEXTURES.get(woodName);
    }

    public static ImmutableMap<String, String> getTextures(IWoodType woodType, WoodBlockKind blockKind) {
        String kindName = blockKind.toString();
        WoodTexture kindTexture = WoodTextureManager.getKindTexture(blockKind);
        WoodTexture tex = WoodTextureManager.getTexture(woodType);
        HashMap<String, String> locations = new HashMap<String, String>();
        if (kindTexture != null && kindTexture instanceof WoodTexture.SimpleTexture) {
            WoodTexture.SimpleTexture texture = (WoodTexture.SimpleTexture)kindTexture;
            locations.putAll((Map<String, String>)texture.getLocations(kindName));
        }
        if (tex != null) {
            locations.putAll((Map<String, String>)tex.getLocations(kindName));
        }
        ImmutableMap.Builder texuresBuilder = new ImmutableMap.Builder();
        block14: for (Map.Entry location : locations.entrySet()) {
            String texture;
            switch (texture = (String)location.getValue()) {
                case "plank": {
                    texture = woodType.getPlankTexture();
                    break;
                }
                case "bark": {
                    texture = woodType.getBarkTexture();
                    break;
                }
                case "heart": {
                    texture = woodType.getHeartTexture();
                    break;
                }
                case "doorUp": {
                    texture = woodType.getDoorUpperTexture();
                    break;
                }
                case "doorLow": {
                    texture = woodType.getDoorLowerTexture();
                    break;
                }
                default: {
                    texuresBuilder.put(location.getKey(), (Object)texture.replace("%woodType", woodType.func_176610_l().toLowerCase(Locale.ENGLISH)));
                    continue block14;
                }
            }
            texuresBuilder.put(location.getKey(), (Object)texture);
        }
        return texuresBuilder.build();
    }
}

