/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.proxy.ProxyArboricultureClient;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockForestryStairs<T extends Enum<T>>
extends BlockStairs
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    private final boolean fireproof;
    private final T woodType;

    public BlockForestryStairs(boolean fireproof, IBlockState modelState, T woodType) {
        super(modelState);
        this.fireproof = fireproof;
        this.woodType = woodType;
        this.func_149647_a(Tabs.tabArboriculture);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{WoodHelper.getDefaultResourceLocations(this)});
        ProxyArboricultureClient.registerWoodMeshDefinition(item, new WoodHelper.WoodMeshDefinition(this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ProxyArboricultureClient.registerWoodStateMapper((Block)this, new WoodTypeStateMapper(this, null));
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Override
    @Nonnull
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.STAIRS;
    }

    @Nonnull
    public T getWoodType(int meta) {
        return this.woodType;
    }

    @Nonnull
    public Collection<T> getWoodTypes() {
        return Collections.singleton(this.woodType);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        T woodType = this.getWoodType(meta);
        return ((IWoodType)woodType).getHardness();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }
}

