/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AlleleEffectPotion
extends AlleleEffectThrottled {
    private final Potion potion;
    private final int potionFXColor;
    private final int duration;
    private final float chance;

    public AlleleEffectPotion(String name, boolean isDominant, Potion potion, int duration, int throttle, float chance) {
        super(name, isDominant, throttle, true, false);
        this.potion = potion;
        this.duration = duration;
        this.chance = chance;
        Set<PotionEffect> potionEffects = Collections.singleton(new PotionEffect(potion, 1, 0));
        this.potionFXColor = PotionUtils.func_185181_a(potionEffects);
    }

    public AlleleEffectPotion(String name, boolean isDominant, Potion potion, int duration) {
        this(name, isDominant, potion, duration, 200, 1.0f);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        List<EntityLivingBase> entities = AlleleEffectPotion.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entity : entities) {
            if (world.field_73012_v.nextFloat() >= this.chance) continue;
            int dur = this.duration;
            if (this.potion.func_76398_f()) {
                int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getUID(), true);
                if (count >= 4) continue;
                if (count == 3) {
                    dur = this.duration / 4;
                } else if (count == 2) {
                    dur = this.duration / 2;
                } else if (count == 1) {
                    dur = this.duration * 3 / 4;
                }
            } else if (entity instanceof IMob) continue;
            entity.func_70690_d(new PotionEffect(this.potion, dur, 0));
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        if (world.field_73012_v.nextBoolean()) {
            super.doFX(genome, storedData, housing);
        } else {
            Vec3d beeFXCoordinates = housing.getBeeFXCoordinates();
            Proxies.render.addEntityPotionFX(world, beeFXCoordinates.field_72450_a, beeFXCoordinates.field_72448_b + 0.5, beeFXCoordinates.field_72449_c, this.potionFXColor);
        }
        return storedData;
    }
}

