/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.ApiaryBeeModifier;
import forestry.apiculture.IApiary;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.entities.EntityMinecartBeeHousingBase;
import forestry.apiculture.gui.ContainerMinecartBeehouse;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.core.config.Config;
import forestry.core.inventory.IInventoryAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityMinecartApiary
extends EntityMinecartBeeHousingBase
implements IApiary {
    @Nonnull
    private static final IBeeModifier beeModifier = new ApiaryBeeModifier();
    @Nonnull
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    @Nonnull
    private final InventoryApiary inventory = new InventoryApiary();

    public EntityMinecartApiary(World world) {
        super(world);
    }

    public EntityMinecartApiary(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"apiary");
    }

    @Override
    protected IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBlockState func_174897_t() {
        return PluginApiculture.blocks.apiary.func_176223_P();
    }

    @Override
    public ItemStack getCartItem() {
        return PluginApiculture.items.minecartBeehouse.getApiaryMinecart();
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(beeModifier);
        for (IHiveFrame frame : this.inventory.getFrames()) {
            beeModifiers.add(frame.getBeeModifier());
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        ContainerMinecartBeehouse container = new ContainerMinecartBeehouse(player.field_71071_by, this, true);
        return new GuiBeeHousing<ContainerMinecartBeehouse>(this, container, GuiBeeHousing.Icon.APIARY);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerMinecartBeehouse(player.field_71071_by, this, true);
    }
}

