/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.util.json.serialization;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.ITypeReader;
import amerifrance.guideapi.api.impl.Category;
import amerifrance.guideapi.api.impl.Entry;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.entry.EntryItemStack;
import amerifrance.guideapi.entry.EntryResourceLocation;
import amerifrance.guideapi.page.PageFurnaceRecipe;
import amerifrance.guideapi.page.PageIRecipe;
import amerifrance.guideapi.page.PageImage;
import amerifrance.guideapi.page.PageItemStack;
import amerifrance.guideapi.page.PageSound;
import amerifrance.guideapi.page.PageText;
import amerifrance.guideapi.page.PageTextImage;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class TypeReaders<T>
implements ITypeReader<T> {
    public static TypeReaders<CategoryAbstract> CATEGORY_ABSTRACT = new TypeReaders<CategoryAbstract>(CategoryAbstract.class){

        public CategoryAbstract deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Map stringEntries = (Map)context.deserialize(json.getAsJsonObject().get("entries"), new TypeToken<Map<String, EntryAbstract>>(){}.getType());
            HashMap<ResourceLocation, EntryAbstract> entries = new HashMap<ResourceLocation, EntryAbstract>();
            for (Map.Entry entry : stringEntries.entrySet()) {
                entries.put(new ResourceLocation((String)entry.getKey()), (EntryAbstract)entry.getValue());
            }
            String name = json.getAsJsonObject().get("name").getAsString();
            return new Category(entries, name);
        }

        @Override
        public void addData(JsonObject jsonObject, CategoryAbstract src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocCategoryName));
            jsonObject.add("entries", context.serialize(src.entries));
        }
    };
    public static TypeReaders<Category> CATEGORY_BASE = new TypeReaders<Category>(Category.class){

        public Category deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Map stringEntries = (Map)context.deserialize(json.getAsJsonObject().get("entries"), new TypeToken<Map<String, EntryAbstract>>(){}.getType());
            HashMap<ResourceLocation, EntryAbstract> entries = new HashMap<ResourceLocation, EntryAbstract>();
            for (Map.Entry entry : stringEntries.entrySet()) {
                entries.put(new ResourceLocation((String)entry.getKey()), (EntryAbstract)entry.getValue());
            }
            String name = json.getAsJsonObject().get("name").getAsString();
            return new Category(entries, name);
        }

        @Override
        public void addData(JsonObject jsonObject, Category src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocCategoryName));
            jsonObject.add("entries", context.serialize((Object)src.entries));
        }
    };
    public static TypeReaders<CategoryItemStack> CATEGORY_ITEMSTACK = new TypeReaders<CategoryItemStack>(CategoryItemStack.class){

        public CategoryItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Map stringEntries = (Map)context.deserialize(json.getAsJsonObject().get("entries"), new TypeToken<Map<String, EntryAbstract>>(){}.getType());
            HashMap<ResourceLocation, EntryAbstract> entries = new HashMap<ResourceLocation, EntryAbstract>();
            for (Map.Entry entry : stringEntries.entrySet()) {
                entries.put(new ResourceLocation((String)entry.getKey()), (EntryAbstract)entry.getValue());
            }
            String name = json.getAsJsonObject().get("name").getAsString();
            ItemStack stack = (ItemStack)context.deserialize(json.getAsJsonObject().get("stack"), ItemStack.class);
            return new CategoryItemStack(entries, name, stack);
        }

        @Override
        public void addData(JsonObject jsonObject, CategoryItemStack src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocCategoryName));
            jsonObject.add("stack", context.serialize((Object)src.stack));
            jsonObject.add("entries", context.serialize((Object)src.entries));
        }
    };
    public static TypeReaders<EntryAbstract> ENTRY_ABSTRACT = new TypeReaders<EntryAbstract>(EntryAbstract.class){

        public EntryAbstract deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            List list = (List)context.deserialize(json.getAsJsonObject().get("pages"), new TypeToken<List<IPage>>(){}.getType());
            return new Entry((List<IPage>)list, name);
        }

        @Override
        public void addData(JsonObject jsonObject, EntryAbstract src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocEntryName));
            jsonObject.add("pages", context.serialize(src.pageList));
        }
    };
    public static TypeReaders<Entry> ENTRY_BASE = new TypeReaders<Entry>(Entry.class){

        public Entry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            List list = (List)context.deserialize(json.getAsJsonObject().get("pages"), new TypeToken<List<IPage>>(){}.getType());
            return new Entry((List<IPage>)list, name);
        }

        @Override
        public void addData(JsonObject jsonObject, Entry src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocEntryName));
            jsonObject.add("pages", context.serialize((Object)src.pageList));
        }
    };
    public static TypeReaders<Entry> ENTRY_TEXT = new TypeReaders<Entry>(Entry.class){

        public Entry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            List list = (List)context.deserialize(json.getAsJsonObject().get("pages"), new TypeToken<List<IPage>>(){}.getType());
            return new Entry((List<IPage>)list, name);
        }

        @Override
        public void addData(JsonObject jsonObject, Entry src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocEntryName));
            jsonObject.add("pages", context.serialize((Object)src.pageList));
        }
    };
    public static TypeReaders<EntryItemStack> ENTRY_ITEMSTACK = new TypeReaders<EntryItemStack>(EntryItemStack.class){

        public EntryItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            ItemStack stack = (ItemStack)context.deserialize(json.getAsJsonObject().get("stack"), ItemStack.class);
            List list = (List)context.deserialize(json.getAsJsonObject().get("pages"), new TypeToken<List<IPage>>(){}.getType());
            return new EntryItemStack((List<IPage>)list, name, stack);
        }

        @Override
        public void addData(JsonObject jsonObject, EntryItemStack src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocEntryName));
            jsonObject.add("stack", context.serialize((Object)src.stack));
            jsonObject.add("pages", context.serialize((Object)src.pageList));
        }
    };
    public static TypeReaders<EntryResourceLocation> ENTRY_IMAGE = new TypeReaders<EntryResourceLocation>(EntryResourceLocation.class){

        public EntryResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            String resource = json.getAsJsonObject().get("resource").getAsString();
            List list = (List)context.deserialize(json.getAsJsonObject().get("pages"), new TypeToken<List<IPage>>(){}.getType());
            return new EntryResourceLocation((List<IPage>)list, name, new ResourceLocation(resource));
        }

        @Override
        public void addData(JsonObject jsonObject, EntryResourceLocation src, JsonSerializationContext context) {
            jsonObject.add("name", context.serialize((Object)src.unlocEntryName));
            jsonObject.add("resource", context.serialize((Object)src.image.toString()));
            jsonObject.add("pages", context.serialize((Object)src.pageList));
        }
    };
    public static TypeReaders<IPage> PAGE_IPAGE = new TypeReaders<IPage>(IPage.class){

        public IPage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ItemStack input = (ItemStack)context.deserialize(json.getAsJsonObject().get("input"), ItemStack.class);
            return new PageFurnaceRecipe(input);
        }

        @Override
        public void addData(JsonObject jsonObject, IPage src, JsonSerializationContext context) {
        }
    };
    public static TypeReaders<PageFurnaceRecipe> PAGE_FURNACE_RECIPE = new TypeReaders<PageFurnaceRecipe>(PageFurnaceRecipe.class){

        public PageFurnaceRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ItemStack input = (ItemStack)context.deserialize(json.getAsJsonObject().get("input"), ItemStack.class);
            return new PageFurnaceRecipe(input);
        }

        @Override
        public void addData(JsonObject jsonObject, PageFurnaceRecipe src, JsonSerializationContext context) {
            jsonObject.add("input", context.serialize((Object)src.input));
        }
    };
    public static TypeReaders<PageImage> PAGE_IMAGE = new TypeReaders<PageImage>(PageImage.class){

        public PageImage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation location = (ResourceLocation)context.deserialize(json.getAsJsonObject().get("image"), ResourceLocation.class);
            return new PageImage(location);
        }

        @Override
        public void addData(JsonObject jsonObject, PageImage src, JsonSerializationContext context) {
            jsonObject.add("image", context.serialize((Object)src.image));
        }
    };
    public static TypeReaders<PageTextImage> PAGE_IMAGE_TEXT = new TypeReaders<PageTextImage>(PageTextImage.class){

        public PageTextImage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation location = (ResourceLocation)context.deserialize(json.getAsJsonObject().get("image"), ResourceLocation.class);
            String text = (String)context.deserialize(json.getAsJsonObject().get("text"), String.class);
            boolean drawAtTop = (Boolean)context.deserialize(json.getAsJsonObject().get("drawAtTop"), Boolean.class);
            return new PageTextImage(text, location, drawAtTop);
        }

        @Override
        public void addData(JsonObject jsonObject, PageTextImage src, JsonSerializationContext context) {
            jsonObject.add("image", context.serialize((Object)src.image));
            jsonObject.add("text", context.serialize((Object)src.draw));
            jsonObject.add("drawAtTop", context.serialize((Object)src.drawAtTop));
        }
    };
    public static TypeReaders<PageIRecipe> PAGE_IRECIPE = new TypeReaders<PageIRecipe>(PageIRecipe.class){

        public PageIRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            IRecipe recipe = (IRecipe)context.deserialize(json.getAsJsonObject().get("recipe"), IRecipe.class);
            return new PageIRecipe(recipe);
        }

        @Override
        public void addData(JsonObject jsonObject, PageIRecipe src, JsonSerializationContext context) {
            jsonObject.add("recipe", context.serialize((Object)src.recipe));
        }
    };
    public static TypeReaders<PageItemStack> PAGE_ITEMSTACK = new TypeReaders<PageItemStack>(PageItemStack.class){

        public PageItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String text = (String)context.deserialize(json.getAsJsonObject().get("text"), String.class);
            ItemStack stack = (ItemStack)context.deserialize(json.getAsJsonObject().get("stack"), ItemStack.class);
            return new PageItemStack(text, stack);
        }

        @Override
        public void addData(JsonObject jsonObject, PageItemStack src, JsonSerializationContext context) {
            jsonObject.add("stack", context.serialize((Object)src.stack));
            jsonObject.add("text", context.serialize((Object)src.draw));
        }
    };
    public static TypeReaders<PageText> PAGE_TEXT = new TypeReaders<PageText>(PageText.class){

        public PageText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String text = (String)context.deserialize(json.getAsJsonObject().get("text"), String.class);
            return new PageText(text);
        }

        @Override
        public void addData(JsonObject jsonObject, PageText src, JsonSerializationContext context) {
            jsonObject.add("text", context.serialize((Object)src.draw));
        }
    };
    public static TypeReaders<PageSound> PAGE_SOUND = new TypeReaders<PageSound>(PageSound.class){

        public PageSound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(json.getAsJsonObject().get("sound").getAsString()));
            IPage pageToEmulate = (IPage)context.deserialize(json.getAsJsonObject().get("pageToEmulate"), IPage.class);
            return new PageSound(pageToEmulate, sound);
        }

        @Override
        public void addData(JsonObject jsonObject, PageSound src, JsonSerializationContext context) {
            jsonObject.addProperty("sound", src.sound.getRegistryName().toString());
            jsonObject.add("pageToEmulate", context.serialize((Object)src.pageToEmulate));
        }
    };
    private Class<? extends T> type;

    private TypeReaders(Class<? extends T> type) {
        this.type = type;
        GuideAPI.addTypeReader(this);
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    public JsonObject serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", (JsonElement)new JsonPrimitive(src.getClass().getSimpleName()));
        this.addData(jsonObject, src, context);
        return jsonObject;
    }

    protected abstract void addData(JsonObject var1, T var2, JsonSerializationContext var3);

    public static void init() {
    }
}

