/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.item;

import amerifrance.guideapi.GuideMod;
import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IGuideItem;
import amerifrance.guideapi.api.IGuideLinked;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.util.TextHelper;
import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGuideBook
extends Item
implements IGuideItem {
    public ItemGuideBook() {
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77655_b("guideapi.book");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.getBook(stack) != null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            player.openGui((Object)GuideMod.instance, stack.func_77952_i(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.getBook(stack) != null && world.func_180495_p(pos).func_177230_c() instanceof IGuideLinked) {
            IGuideLinked guideLinked = (IGuideLinked)world.func_180495_p(pos).func_177230_c();
            Book book = this.getBook(stack);
            ResourceLocation entryKey = guideLinked.getLinkedEntry(world, pos, player, stack);
            for (CategoryAbstract category : book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                GuideMod.proxy.openEntry(book, category, category.entries.get(entryKey), player, stack);
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public String func_77667_c(ItemStack stack) {
        return this.getBook(stack) != null ? this.func_77658_a() + "." + String.valueOf(stack.func_77952_i()) : super.func_77667_c(stack);
    }

    public String func_77653_i(ItemStack stack) {
        return this.getBook(stack) != null ? this.getBook(stack).getLocalizedDisplayName() : super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        if (!GuideAPI.BOOKS.getValues().isEmpty()) {
            for (Book book : GuideAPI.BOOKS.getValues()) {
                list.add(new ItemStack((Item)this, 1, GuideAPI.BOOKS.getValues().indexOf((Object)book)));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        Book book = this.getBook(stack);
        if (book == null) {
            list.add(TextHelper.localizeEffect("text.book.warning", new Object[0]));
        }
        if (book != null) {
            if (!Strings.isNullOrEmpty((String)book.getAuthor())) {
                list.add(TextHelper.localizeEffect(book.getAuthor(), new Object[0]));
            }
            if (Strings.isNullOrEmpty((String)book.getAuthor()) && advanced) {
                list.add(book.getRegistryName().func_110624_b());
            }
        }
    }

    @Override
    public Book getBook(ItemStack stack) {
        if (GuideAPI.BOOKS.getValues().size() > stack.func_77952_i()) {
            return (Book)((Object)GuideAPI.BOOKS.getValues().get(stack.func_77952_i()));
        }
        return null;
    }
}

