/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import javax.annotation.Nullable;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.MathTools;
import mcjty.lib.tools.MinecraftTools;
import mcjty.theoneprobe.TheOneProbe;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class RenderHelper {
    public static float rot = 0.0f;

    public static void renderEntity(Entity entity, int xPos, int yPos, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(xPos + 8), (float)(yPos + 24), (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70125_A = 0.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)((float)entity.func_70033_W()), (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        try {
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        }
        catch (Exception e) {
            TheOneProbe.logger.error("Error rendering entity!", (Throwable)e);
        }
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179119_h();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static boolean renderObject(Minecraft mc, int x, int y, Object itm, boolean highlight) {
        if (itm instanceof Entity) {
            RenderHelper.renderEntity((Entity)itm, x, y, 10.0f);
            return true;
        }
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        return RenderHelper.renderObject(mc, itemRender, x, y, itm, highlight, 200.0f);
    }

    public static boolean renderObject(Minecraft mc, RenderItem itemRender, int x, int y, Object itm, boolean highlight, float lvl) {
        itemRender.field_77023_b = lvl;
        if (itm == null) {
            return RenderHelper.renderItemStack(mc, itemRender, null, x, y, "", highlight);
        }
        if (itm instanceof Item) {
            return RenderHelper.renderItemStack(mc, itemRender, new ItemStack((Item)itm, 1), x, y, "", highlight);
        }
        if (itm instanceof Block) {
            return RenderHelper.renderItemStack(mc, itemRender, new ItemStack((Block)itm, 1), x, y, "", highlight);
        }
        if (itm instanceof ItemStack) {
            return RenderHelper.renderItemStackWithCount(mc, itemRender, (ItemStack)itm, x, y, highlight);
        }
        if (itm instanceof TextureAtlasSprite) {
            return RenderHelper.renderIcon(mc, itemRender, (TextureAtlasSprite)itm, x, y, highlight);
        }
        return RenderHelper.renderItemStack(mc, itemRender, ItemStackTools.getEmptyStack(), x, y, "", highlight);
    }

    public static boolean renderIcon(Minecraft mc, RenderItem itemRender, TextureAtlasSprite itm, int xo, int yo, boolean highlight) {
        return true;
    }

    public static boolean renderItemStackWithCount(Minecraft mc, RenderItem itemRender, ItemStack itm, int xo, int yo, boolean highlight) {
        if (ItemStackTools.getStackSize((ItemStack)itm) == 1 || ItemStackTools.getStackSize((ItemStack)itm) == 0) {
            return RenderHelper.renderItemStack(mc, itemRender, itm, xo, yo, "", highlight);
        }
        return RenderHelper.renderItemStack(mc, itemRender, itm, xo, yo, "" + ItemStackTools.getStackSize((ItemStack)itm), highlight);
    }

    public static boolean renderItemStack(Minecraft mc, RenderItem itemRender, ItemStack itm, int x, int y, String txt, boolean highlight) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = false;
        if (highlight) {
            GlStateManager.func_179140_f();
            RenderHelper.drawVerticalGradientRect(x, y, x + 16, y + 16, -2130706433, -1);
        }
        if (ItemStackTools.isValid((ItemStack)itm) && itm.func_77973_b() != null) {
            rc = true;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179145_e();
            int short1 = 240;
            int short2 = 240;
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
            itemRender.func_180450_b(itm, x, y);
            itemRender.func_180453_a(mc.field_71466_p, itm, x, y, txt);
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
        }
        return rc;
    }

    public static void drawVerticalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x2, (double)y1, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y2, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawHorizontalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        float zLevel = 0.0f;
        float f = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color1 & 0xFF) / 255.0f;
        float f4 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(color2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x1, (double)y1, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y2, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawHorizontalLine(int x1, int y1, int x2, int color) {
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawVerticalLine(int x1, int y1, int y2, int color) {
        Gui.func_73734_a((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    public static void drawLeftTriangle(int x, int y, int color) {
        RenderHelper.drawVerticalLine(x, y, y, color);
        RenderHelper.drawVerticalLine(x + 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(x + 2, y - 2, y + 2, color);
    }

    public static void drawRightTriangle(int x, int y, int color) {
        RenderHelper.drawVerticalLine(x, y, y, color);
        RenderHelper.drawVerticalLine(x - 1, y - 1, y + 1, color);
        RenderHelper.drawVerticalLine(x - 2, y - 2, y + 2, color);
    }

    public static void drawUpTriangle(int x, int y, int color) {
        RenderHelper.drawHorizontalLine(x, y, x, color);
        RenderHelper.drawHorizontalLine(x - 1, y + 1, x + 1, color);
        RenderHelper.drawHorizontalLine(x - 2, y + 2, x + 2, color);
    }

    public static void drawDownTriangle(int x, int y, int color) {
        RenderHelper.drawHorizontalLine(x, y, x, color);
        RenderHelper.drawHorizontalLine(x - 1, y - 1, x + 1, color);
        RenderHelper.drawHorizontalLine(x - 2, y - 2, x + 2, color);
    }

    public static void drawFlatButtonBox(int x1, int y1, int x2, int y2, int bright, int average, int dark) {
        RenderHelper.drawBeveledBox(x1, y1, x2, y2, bright, dark, average);
    }

    public static void drawFlatButtonBoxGradient(int x1, int y1, int x2, int y2, int bright, int average1, int average2, int dark) {
        RenderHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, average2, average1);
        RenderHelper.drawHorizontalLine(x1, y1, x2 - 1, bright);
        RenderHelper.drawVerticalLine(x1, y1, y2 - 1, bright);
        RenderHelper.drawVerticalLine(x2 - 1, y1, y2 - 1, dark);
        RenderHelper.drawHorizontalLine(x1, y2 - 1, x2, dark);
    }

    public static void drawBeveledBox(int x1, int y1, int x2, int y2, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            Gui.func_73734_a((int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        RenderHelper.drawHorizontalLine(x1, y1, x2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(x1, y1, y2 - 1, topleftcolor);
        RenderHelper.drawVerticalLine(x2 - 1, y1, y2 - 1, botrightcolor);
        RenderHelper.drawHorizontalLine(x1, y2 - 1, x2, botrightcolor);
    }

    public static void drawThickBeveledBox(int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            Gui.func_73734_a((int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        Gui.func_73734_a((int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        Gui.func_73734_a((int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        Gui.func_73734_a((int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        Gui.func_73734_a((int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int twidth, int theight) {
        float zLevel = 0.01f;
        float f = 1.0f / (float)twidth;
        float f1 = 1.0f / (float)theight;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)((float)(u + 0) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int x, int y, TextureAtlasSprite sprite, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        float u2 = sprite.func_94212_f();
        float v2 = sprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_187315_a((double)u1, (double)v1).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)u1, (double)v2).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_187315_a((double)u2, (double)v2).func_181675_d();
        buffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_187315_a((double)u2, (double)v1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderBillboardQuadBright(double scale) {
        int brightness = 240;
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        GlStateManager.func_179094_E();
        RenderHelper.rotateToPlayer();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        buffer.func_181662_b(-scale, -scale, 0.0).func_187315_a(0.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(-scale, scale, 0.0).func_187315_a(0.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(scale, scale, 0.0).func_187315_a(1.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(scale, -scale, 0.0).func_187315_a(1.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderBillboardQuad(double scale) {
        GlStateManager.func_179094_E();
        RenderHelper.rotateToPlayer();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-scale, -scale, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-scale, scale, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(scale, scale, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(scale, -scale, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderBillboardQuadWithRotation(float rot, double scale) {
        GlStateManager.func_179094_E();
        RenderHelper.rotateToPlayer();
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-scale, -scale, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-scale, scale, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(scale, scale, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(scale, -scale, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void rotateToPlayer() {
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static void drawBeam(Vector S, Vector E, Vector P, float width) {
        Vector PS = RenderHelper.Sub(S, P);
        Vector SE = RenderHelper.Sub(E, S);
        Vector normal = RenderHelper.Cross(PS, SE);
        normal = normal.normalize();
        Vector half = RenderHelper.Mul(normal, width);
        Vector p1 = RenderHelper.Add(S, half);
        Vector p2 = RenderHelper.Sub(S, half);
        Vector p3 = RenderHelper.Add(E, half);
        Vector p4 = RenderHelper.Sub(E, half);
        RenderHelper.drawQuad(Tessellator.func_178181_a(), p1, p3, p4, p2);
    }

    private static void drawQuad(Tessellator tessellator, Vector p1, Vector p2, Vector p3, Vector p4) {
        int brightness = 240;
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181662_b((double)p1.getX(), (double)p1.getY(), (double)p1.getZ()).func_187315_a(0.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b((double)p2.getX(), (double)p2.getY(), (double)p2.getZ()).func_187315_a(1.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b((double)p3.getX(), (double)p3.getY(), (double)p3.getZ()).func_187315_a(1.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b((double)p4.getX(), (double)p4.getY(), (double)p4.getZ()).func_187315_a(0.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
    }

    public static int renderItemStack(Minecraft mc, RenderItem itemRender, ItemStack itm, int x, int y, String txt) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int rc = 0;
        if (ItemStackTools.isValid((ItemStack)itm) && itm.func_77973_b() != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179145_e();
            int short1 = 240;
            int short2 = 240;
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)short1 / 1.0f), (float)((float)short2 / 1.0f));
            itemRender.func_180450_b(itm, x, y);
            RenderHelper.renderItemOverlayIntoGUI(mc.field_71466_p, itm, x, y, txt, txt.length() - 2);
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            rc = 20;
        }
        return rc;
    }

    public static void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        if (ItemStackTools.isValid((ItemStack)stack)) {
            EntityPlayerSP entityplayersp;
            float f;
            if (ItemStackTools.getStackSize((ItemStack)stack) != 1 || text != null) {
                String s;
                String string = s = text == null ? String.valueOf(ItemStackTools.getStackSize((ItemStack)stack)) : text;
                if (text == null && ItemStackTools.getStackSize((ItemStack)stack) < 1) {
                    s = TextFormatting.RED + String.valueOf(ItemStackTools.getStackSize((ItemStack)stack));
                }
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                if (scaled >= 2) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                    fr.func_175063_a(s, (float)((xPosition + 19 - 2) * 2 - 1 - fr.func_78256_a(s)), (float)(yPosition * 2 + 24), 0xFFFFFF);
                    GlStateManager.func_179121_F();
                } else if (scaled == 1) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                    fr.func_175063_a(s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.func_78256_a(s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                } else {
                    fr.func_175063_a(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                }
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int j = (int)Math.round(13.0 - health * 13.0);
                int i = (int)Math.round(255.0 - health * 255.0);
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                Tessellator tessellator = Tessellator.func_178181_a();
                VertexBuffer vertexbuffer = tessellator.func_178180_c();
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderHelper.draw(vertexbuffer, xPosition + 2, yPosition + 13, j, 1, 255 - i, i, 0, 255);
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            float f2 = f = (entityplayersp = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x())) == null ? 0.0f : entityplayersp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f > 0.0f) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                VertexBuffer vertexbuffer1 = tessellator1.func_178180_c();
                RenderHelper.draw(vertexbuffer1, xPosition, yPosition + MathTools.floor((float)(16.0f * (1.0f - f))), 16, MathTools.ceiling((float)(16.0f * f)), 255, 255, 255, 127);
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        }
    }

    private static void draw(VertexBuffer renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static int renderText(Minecraft mc, int x, int y, String txt) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        int width = mc.field_71466_p.func_78256_a(txt);
        mc.field_71466_p.func_175063_a(txt, (float)x, (float)y, 0xFFFFFF);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        return width;
    }

    private static Vector Cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    private static Vector Sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector Add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector Mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

