/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.util.HashMap;
import java.util.Map;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class HarvestInfoTools {
    private static final ResourceLocation ICONS = new ResourceLocation("theoneprobe", "textures/gui/icons.png");
    private static String[] harvestLevels = new String[]{"stone", "iron", "diamond", "obsidian", "cobalt"};
    private static final HashMap<String, ItemStack> testTools = new HashMap();

    static void showHarvestLevel(IProbeInfo probeInfo, IBlockState blockState, Block block) {
        String harvestTool = block.getHarvestTool(blockState);
        if (harvestTool != null) {
            int harvestLevel = block.getHarvestLevel(blockState);
            String harvestName = harvestLevel >= harvestLevels.length ? Integer.toString(harvestLevel) : (harvestLevel < 0 ? Integer.toString(harvestLevel) : harvestLevels[harvestLevel]);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Tool: " + (Object)((Object)TextStyleClass.INFO) + harvestTool + " (level " + harvestName + ")");
        }
    }

    static void showCanBeHarvested(IProbeInfo probeInfo, World world, BlockPos pos, Block block, EntityPlayer player) {
        boolean harvestable;
        if (ModItems.isProbeInHand(player.func_184614_ca())) {
            return;
        }
        boolean bl = harvestable = block.canHarvestBlock((IBlockAccess)world, pos, player) && world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f;
        if (harvestable) {
            probeInfo.text((Object)((Object)TextStyleClass.OK) + "Harvestable");
        } else {
            probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "Not harvestable");
        }
    }

    static void showHarvestInfo(IProbeInfo probeInfo, World world, BlockPos pos, Block block, IBlockState blockState, EntityPlayer player) {
        boolean v;
        float blockHardness;
        boolean harvestable = block.canHarvestBlock((IBlockAccess)world, pos, player) && world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f;
        String harvestTool = block.getHarvestTool(blockState);
        String harvestName = null;
        if (harvestTool == null && (blockHardness = blockState.func_185887_b(world, pos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> testToolEntry : testTools.entrySet()) {
                ItemStack testTool = testToolEntry.getValue();
                if (testTool == null || !(testTool.func_77973_b() instanceof ItemTool)) continue;
                ItemTool toolItem = (ItemTool)testTool.func_77973_b();
                if (!(testTool.func_150997_a(blockState) >= toolItem.func_150913_i().func_77998_b())) continue;
                harvestTool = testToolEntry.getKey();
                break;
            }
        }
        if (harvestTool != null) {
            int harvestLevel = block.getHarvestLevel(blockState);
            if (harvestLevel >= 0 && harvestLevel < harvestLevels.length) {
                harvestName = harvestLevels[harvestLevel];
            }
            harvestTool = StringUtils.capitalize((String)harvestTool);
        }
        int offs = (v = Config.harvestStyleVanilla) ? 16 : 0;
        int dim = v ? 13 : 16;
        ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
        IProbeInfo horizontal = probeInfo.horizontal(alignment);
        if (harvestable) {
            horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.OK) + (harvestTool != null ? harvestTool : "No tool"));
        } else if (harvestName == null || harvestName.isEmpty()) {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.WARNING) + (harvestTool != null ? harvestTool : "No tool"));
        } else {
            horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text((Object)((Object)TextStyleClass.WARNING) + (harvestTool != null ? harvestTool : "No tool") + " (" + harvestName + ")");
        }
    }

    static {
        testTools.put("shovel", new ItemStack(Items.field_151038_n));
        testTools.put("axe", new ItemStack(Items.field_151053_p));
        testTools.put("pickaxe", new ItemStack(Items.field_151039_o));
    }
}

