/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import mcjty.lib.tools.ItemStackTools;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.item.ItemStack;

public class ElementItemLabel
implements IElement {
    private final ItemStack itemStack;

    public ElementItemLabel(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ElementItemLabel(ByteBuf buf) {
        this.itemStack = buf.readBoolean() ? NetworkTools.readItemStack(buf) : ItemStackTools.getEmptyStack();
    }

    @Override
    public void render(int x, int y) {
        if (ItemStackTools.isValid((ItemStack)this.itemStack)) {
            String text = this.itemStack.func_82833_r();
            ElementTextRender.render(text, x, y);
        }
    }

    @Override
    public int getWidth() {
        if (ItemStackTools.isValid((ItemStack)this.itemStack)) {
            String text = this.itemStack.func_82833_r();
            return ElementTextRender.getWidth(text);
        }
        return 10;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (ItemStackTools.isValid((ItemStack)this.itemStack)) {
            buf.writeBoolean(true);
            NetworkTools.writeItemStack(buf, this.itemStack);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ITEMLABEL;
    }
}

