/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class UtilShape {
    public static List<BlockPos> repeatShapeByHeight(List<BlockPos> shape, int height) {
        ArrayList<BlockPos> newShape = new ArrayList<BlockPos>();
        newShape.addAll(shape);
        for (int i = 1; i <= height; ++i) {
            for (BlockPos p : shape) {
                newShape.add(p.func_177981_b(i));
            }
        }
        return newShape;
    }

    public static List<BlockPos> circleVertical(BlockPos pos, int diameter) {
        int radius;
        int centerX = pos.func_177958_n();
        int centerZ = pos.func_177956_o();
        int w = pos.func_177952_p();
        int y = radius = diameter / 2;
        int x = 0;
        int d = 2 - 2 * radius;
        ArrayList<BlockPos> circleList = new ArrayList<BlockPos>();
        do {
            circleList.add(new BlockPos(centerX + x, centerZ + y, w));
            circleList.add(new BlockPos(centerX + x, centerZ - y, w));
            circleList.add(new BlockPos(centerX - x, centerZ + y, w));
            circleList.add(new BlockPos(centerX - x, centerZ - y, w));
            circleList.add(new BlockPos(centerX + y, centerZ + x, w));
            circleList.add(new BlockPos(centerX + y, centerZ - x, w));
            circleList.add(new BlockPos(centerX - y, centerZ + x, w));
            circleList.add(new BlockPos(centerX - y, centerZ - x, w));
            if (d < 0) {
                d = d + 4 * x + 6;
                continue;
            }
            d = d + 4 * (x - y) + 10;
            --y;
        } while (++x <= y);
        Collections.sort(circleList, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos object1, BlockPos object2) {
                return object1.func_177958_n() - object2.func_177958_n();
            }
        });
        return circleList;
    }

    public static List<BlockPos> circleHorizontal(BlockPos pos, int diameter) {
        int radius;
        int centerX = pos.func_177958_n();
        int centerZ = pos.func_177952_p();
        int height = pos.func_177956_o();
        int z = radius = diameter / 2;
        int x = 0;
        int d = 2 - 2 * radius;
        ArrayList<BlockPos> circleList = new ArrayList<BlockPos>();
        do {
            circleList.add(new BlockPos(centerX + x, height, centerZ + z));
            circleList.add(new BlockPos(centerX + x, height, centerZ - z));
            circleList.add(new BlockPos(centerX - x, height, centerZ + z));
            circleList.add(new BlockPos(centerX - x, height, centerZ - z));
            circleList.add(new BlockPos(centerX + z, height, centerZ + x));
            circleList.add(new BlockPos(centerX + z, height, centerZ - x));
            circleList.add(new BlockPos(centerX - z, height, centerZ + x));
            circleList.add(new BlockPos(centerX - z, height, centerZ - x));
            if (d < 0) {
                d = d + 4 * x + 6;
                continue;
            }
            d = d + 4 * (x - z) + 10;
            --z;
        } while (++x <= z);
        Collections.sort(circleList, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos object1, BlockPos object2) {
                return object1.func_177958_n() - object2.func_177958_n();
            }
        });
        return circleList;
    }

    public static List<BlockPos> cubeFrame(BlockPos posCenter, int radius, int height) {
        BlockPos botCenter = posCenter;
        BlockPos topCenter = posCenter.func_177982_a(0, height, 0);
        List<BlockPos> cube = UtilShape.squareHorizontalHollow(topCenter, radius);
        cube.addAll(UtilShape.squareHorizontalHollow(botCenter, radius));
        BlockPos b1 = botCenter.func_177982_a(radius, 0, radius);
        BlockPos b2 = botCenter.func_177982_a(radius, 0, -1 * radius);
        BlockPos b3 = botCenter.func_177982_a(-1 * radius, 0, -1 * radius);
        BlockPos b4 = botCenter.func_177982_a(-1 * radius, 0, radius);
        int sideLen = height - 1;
        cube.addAll(UtilShape.line(b1, EnumFacing.UP, sideLen));
        cube.addAll(UtilShape.line(b2, EnumFacing.UP, sideLen));
        cube.addAll(UtilShape.line(b3, EnumFacing.UP, sideLen));
        cube.addAll(UtilShape.line(b4, EnumFacing.UP, sideLen));
        return cube;
    }

    public static List<BlockPos> cubeFilled(BlockPos posCenter, int radius, int height) {
        BlockPos botCenter = posCenter;
        List<BlockPos> cube = UtilShape.squareHorizontalFull(botCenter, radius);
        for (int i = 1; i <= height; ++i) {
            BlockPos botCurrent = botCenter.func_177982_a(0, i, 0);
            cube.addAll(UtilShape.squareHorizontalFull(botCurrent, radius));
        }
        return cube;
    }

    public static List<BlockPos> squareVerticalX(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int yMin = pos.func_177956_o() - radius;
        int yMax = pos.func_177956_o() + radius;
        int z = pos.func_177952_p();
        for (int x = xMin; x <= xMax; ++x) {
            shape.add(new BlockPos(x, yMin, z));
            shape.add(new BlockPos(x, yMax, z));
        }
        for (int y = yMin + 1; y < yMax; ++y) {
            shape.add(new BlockPos(xMin, y, z));
            shape.add(new BlockPos(xMax, y, z));
        }
        return shape;
    }

    public static List<BlockPos> squareVerticalZ(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int x = pos.func_177958_n();
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        int yMin = pos.func_177956_o() - radius;
        int yMax = pos.func_177956_o() + radius;
        for (int z = zMin; z <= zMax; ++z) {
            shape.add(new BlockPos(x, yMin, z));
            shape.add(new BlockPos(x, yMax, z));
        }
        for (int y = yMin + 1; y < yMax; ++y) {
            shape.add(new BlockPos(x, y, zMin));
            shape.add(new BlockPos(x, y, zMax));
        }
        return shape;
    }

    public static List<BlockPos> squareHorizontalFull(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        int y = pos.func_177956_o();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z < zMax; ++z) {
                shape.add(new BlockPos(x, y, z));
                shape.add(new BlockPos(x, y, z));
            }
        }
        return shape;
    }

    public static List<BlockPos> squareHorizontalHollow(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        int y = pos.func_177956_o();
        for (int x = xMin; x <= xMax; ++x) {
            shape.add(new BlockPos(x, y, zMin));
            shape.add(new BlockPos(x, y, zMax));
        }
        for (int z = zMin + 1; z < zMax; ++z) {
            shape.add(new BlockPos(xMin, y, z));
            shape.add(new BlockPos(xMax, y, z));
        }
        return shape;
    }

    public static List<BlockPos> stairway(BlockPos posCurrent, EnumFacing pfacing, int want, boolean isLookingUp) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        boolean goVert = false;
        for (int i = 1; i < want + 1; ++i) {
            posCurrent = goVert ? (isLookingUp ? posCurrent.func_177984_a() : posCurrent.func_177977_b()) : posCurrent.func_177972_a(pfacing);
            shape.add(posCurrent);
            goVert = i % 2 == 0;
        }
        return shape;
    }

    public static List<BlockPos> line(BlockPos pos, EnumFacing efacing, int want) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int skip = 1;
        for (int i = 1; i < want + 1; i += skip) {
            shape.add(pos.func_177967_a(efacing, i));
        }
        return shape;
    }

    public static List<BlockPos> sphere(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radiusInner = radius - 1;
        for (int xCurr = x - radius; xCurr <= x + radius; ++xCurr) {
            for (int yCurr = y - radius; yCurr <= y + radius; ++yCurr) {
                for (int zCurr = z - radius; zCurr <= z + radius; ++zCurr) {
                    int squareDistance = (xCurr - x) * (xCurr - x) + (yCurr - y) * (yCurr - y) + (zCurr - z) * (zCurr - z);
                    if (squareDistance > radius * radius || squareDistance < radiusInner * radiusInner) continue;
                    shape.add(new BlockPos(xCurr, yCurr, zCurr));
                }
            }
        }
        return shape;
    }
}

