/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.potion.PotionBase;
import com.lothrazar.cyclicmagic.potion.PotionEnder;
import com.lothrazar.cyclicmagic.potion.PotionMagnet;
import com.lothrazar.cyclicmagic.potion.PotionSlowfall;
import com.lothrazar.cyclicmagic.potion.PotionSnow;
import com.lothrazar.cyclicmagic.potion.PotionSwimSpeed;
import com.lothrazar.cyclicmagic.potion.PotionWaterwalk;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class PotionEffectRegistry {
    public static final PotionBase slowfallEffect = new PotionSlowfall("slowfall", true, 0);
    public static final PotionBase magnetEffect = new PotionMagnet("magnet", true, 0);
    public static final PotionBase enderEffect = new PotionEnder("ender", true, 0);
    public static final PotionBase waterwalkEffect = new PotionWaterwalk("waterwalk", true, 0);
    public static final PotionBase snowEffect = new PotionSnow("snow", true, 0);
    public static final PotionBase swimSpeedEffect = new PotionSwimSpeed("swimspeed", true, 0);
    public static ArrayList<PotionBase> potionEffects = new ArrayList();

    public static void register() {
        PotionEffectRegistry.registerPotionEffect(magnetEffect);
        PotionEffectRegistry.registerPotionEffect(enderEffect);
        PotionEffectRegistry.registerPotionEffect(waterwalkEffect);
        PotionEffectRegistry.registerPotionEffect(slowfallEffect);
        PotionEffectRegistry.registerPotionEffect(snowEffect);
        PotionEffectRegistry.registerPotionEffect(swimSpeedEffect);
    }

    public static void registerPotionEffect(PotionBase effect) {
        GameRegistry.register((IForgeRegistryEntry)effect, (ResourceLocation)effect.getIcon());
        potionEffects.add(effect);
        ModCyclic.instance.events.register((Object)effect);
    }

    public static String getStrForLevel(int lvl) {
        switch (lvl) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
        }
        return "";
    }

    public static enum PotionType {
        NORMAL,
        POWERED,
        LONG;

    }
}

