/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.block.BlockDimensionOre;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.world.gen.WorldGenEmeraldHeight;
import com.lothrazar.cyclicmagic.world.gen.WorldGenEndOre;
import com.lothrazar.cyclicmagic.world.gen.WorldGenGoldRiver;
import com.lothrazar.cyclicmagic.world.gen.WorldGenNetherOre;
import com.lothrazar.cyclicmagic.world.gen.WorldGenOcean;
import com.lothrazar.cyclicmagic.world.gen.WorldGenOreSingleton;
import com.lothrazar.cyclicmagic.world.gen.WorldGenPlantBiome;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldGenModule
extends BaseEventModule
implements IHasConfig {
    private static final int spawnsCarrot = 15;
    private static final int spawnsWheat = 8;
    private static final int spawnsBeetroot = 18;
    private static final int spawnsPotatoes = 10;
    static final int weightOre = 0;
    static final int weightPlants = 2;
    public static boolean oceanEnabled;
    public static boolean netherOreEnabled;
    public static boolean endOreEnabled;
    public static boolean oreSpawns;
    private static boolean emeraldHeight;
    private static boolean goldRiver;
    private static boolean oreSingletons;
    private static boolean biomeCrops;
    public static BlockDimensionOre nether_gold_ore;
    public static BlockDimensionOre nether_coal_ore;
    public static BlockDimensionOre nether_lapis_ore;
    public static BlockDimensionOre nether_emerald_ore;
    public static BlockDimensionOre nether_diamond_ore;
    public static BlockDimensionOre nether_iron_ore;
    public static BlockDimensionOre end_redstone_ore;
    public static BlockDimensionOre end_coal_ore;
    public static BlockDimensionOre end_lapis_ore;
    public static BlockDimensionOre end_iron_ore;
    public static BlockDimensionOre end_emerald_ore;
    public static BlockDimensionOre end_diamond_ore;
    public static BlockDimensionOre end_gold_ore;
    public static BlockDimensionOre nether_redstone_ore;

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.world generation";
        config.setCategoryComment(category, "Control any blocks that get generated in new chunks & new worlds");
        Property prop = config.get(category, "Classic Oceans", true, "Generate clay, sand, and dirt in the ocean instead of only gravel (like the old days)");
        prop.setRequiresWorldRestart(true);
        oceanEnabled = prop.getBoolean();
        prop = config.get(category, "Nether Ore", true, "Generate ore in netherrack (lapis, emerald, gold, coal, diamond).  The gold gives nuggets when mined");
        prop.setRequiresMcRestart(true);
        netherOreEnabled = prop.getBoolean();
        prop = config.get(category, "End Ore", true, "Generate ore in the end (lapis, emerald, redstone, coal, diamond)");
        prop.setRequiresMcRestart(true);
        endOreEnabled = prop.getBoolean();
        prop = config.get(category, "Infested Ores", true, "These dimension ores (nether and end) have a chance to spawn endermites or silverfish");
        oreSpawns = prop.getBoolean();
        prop = config.get(category, "Emerald Ore Boost", true, "Vanilla emerald ore now can spawn at any height, not only below the ground [still only in the Extreme Hills biomes as normal]");
        prop.setRequiresMcRestart(true);
        emeraldHeight = prop.getBoolean();
        prop = config.get(category, "Gold Rivers", true, "Vanilla gold ore can spawn in and river biomes at any height");
        prop.setRequiresMcRestart(true);
        goldRiver = prop.getBoolean();
        prop = config.get(category, "Ore Singletons", true, "Vanilla ores of all kinds can rarely spawn at all world heights, but only in veins of size one.  Great for amplified terrain.");
        prop.setRequiresMcRestart(true);
        oreSingletons = prop.getBoolean();
        prop = config.get(category, "Biome Crops", true, "Crops spawn randomly with nature.  Carrots in extreme hills, wheat in plains, beetroot in forests, potatoes in taiga.");
        prop.setRequiresMcRestart(true);
        biomeCrops = prop.getBoolean();
        WorldGenOcean.syncConfig(config);
        category = "cyclicmagic.world generation.netherorecustom";
        String blockCountDesc = "Approximate ore vein size.  Zero means no spawns.";
        String spawnChanceDesc = "Chance of a vein to spawn.  Zero means no spawns.";
        WorldGenNetherOre.Configs.blockCountCoal = config.getInt("blockCountCoal", category, 8, 0, 32, blockCountDesc);
        WorldGenNetherOre.Configs.blockCountDiamond = config.getInt("blockCountDiamond", category, 8, 0, 32, blockCountDesc);
        WorldGenNetherOre.Configs.blockCountEmerald = config.getInt("blockCountEmerald", category, 8, 0, 32, blockCountDesc);
        WorldGenNetherOre.Configs.blockCountIron = config.getInt("blockCountIron", category, 8, 0, 32, blockCountDesc);
        WorldGenNetherOre.Configs.blockCountGold = config.getInt("blockCountGold", category, 8, 0, 32, blockCountDesc);
        WorldGenNetherOre.Configs.blockCountLapis = config.getInt("blockCountLapis", category, 8, 0, 32, blockCountDesc);
        WorldGenNetherOre.Configs.blockCountRedstone = config.getInt("blockCountRedstone", category, 8, 0, 32, blockCountDesc);
        WorldGenNetherOre.Configs.spawnChanceCoal = config.getInt("spawnChanceCoal", category, 25, 0, 100, spawnChanceDesc);
        WorldGenNetherOre.Configs.spawnChanceDiamond = config.getInt("spawnChanceDiamond", category, 6, 0, 100, spawnChanceDesc);
        WorldGenNetherOre.Configs.spawnChanceEmerald = config.getInt("spawnChanceEmerald", category, 5, 0, 100, spawnChanceDesc);
        WorldGenNetherOre.Configs.spawnChanceGold = config.getInt("spawnChanceGold", category, 45, 0, 100, spawnChanceDesc);
        WorldGenNetherOre.Configs.spawnChanceLapis = config.getInt("spawnChanceLapis", category, 10, 0, 100, spawnChanceDesc);
        WorldGenNetherOre.Configs.spawnChanceIron = config.getInt("spawnChanceIron", category, 15, 0, 100, spawnChanceDesc);
        WorldGenNetherOre.Configs.spawnChanceRedstone = config.getInt("spawnChanceRedstone", category, 8, 0, 100, spawnChanceDesc);
        category = "cyclicmagic.world generation.endorecustom";
        WorldGenEndOre.Configs.blockCountCoal = config.getInt("blockCountCoal", category, 8, 0, 32, blockCountDesc);
        WorldGenEndOre.Configs.blockCountDiamond = config.getInt("blockCountDiamond", category, 8, 0, 32, blockCountDesc);
        WorldGenEndOre.Configs.blockCountEmerald = config.getInt("blockCountEmerald", category, 8, 0, 32, blockCountDesc);
        WorldGenEndOre.Configs.blockCountRedstone = config.getInt("blockCountRedstone", category, 8, 0, 32, blockCountDesc);
        WorldGenEndOre.Configs.blockCountLapis = config.getInt("blockCountLapis", category, 8, 0, 32, blockCountDesc);
        WorldGenEndOre.Configs.blockCountIron = config.getInt("blockCountIron", category, 8, 0, 32, blockCountDesc);
        WorldGenEndOre.Configs.blockCountGold = config.getInt("blockCountGold", category, 8, 0, 32, blockCountDesc);
        WorldGenEndOre.Configs.spawnChanceCoal = config.getInt("spawnChanceCoal", category, 20, 0, 100, spawnChanceDesc);
        WorldGenEndOre.Configs.spawnChanceDiamond = config.getInt("spawnChanceDiamond", category, 10, 0, 100, spawnChanceDesc);
        WorldGenEndOre.Configs.spawnChanceEmerald = config.getInt("spawnChanceEmerald", category, 10, 0, 100, spawnChanceDesc);
        WorldGenEndOre.Configs.spawnChanceRedstone = config.getInt("spawnChanceRedstone", category, 18, 0, 100, spawnChanceDesc);
        WorldGenEndOre.Configs.spawnChanceLapis = config.getInt("spawnChanceLapis", category, 15, 0, 100, spawnChanceDesc);
        WorldGenEndOre.Configs.spawnChanceIron = config.getInt("spawnChanceIron", category, 12, 0, 100, spawnChanceDesc);
        WorldGenEndOre.Configs.spawnChanceGold = config.getInt("spawnChanceGold", category, 12, 0, 100, spawnChanceDesc);
    }

    @Override
    public void onInit() {
        if (oceanEnabled) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOcean(), (int)0);
        }
        if (netherOreEnabled || endOreEnabled) {
            this.registerDimensionOres();
        }
        if (netherOreEnabled) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherOre(), (int)0);
        }
        if (endOreEnabled) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenEndOre(), (int)0);
        }
        if (emeraldHeight) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenEmeraldHeight(), (int)0);
        }
        if (goldRiver) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenGoldRiver(), (int)0);
        }
        if (oreSingletons) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150366_p, 68), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150352_o, 34), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150369_x, 34), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150450_ax, 16), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150482_ag, 16), (int)0);
        }
        if (biomeCrops) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_150459_bM, Arrays.asList(Biomes.field_76770_e), 15), (int)2);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_150464_aj, Arrays.asList(Biomes.field_76772_c), 8), (int)2);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_185773_cZ, Arrays.asList(Biomes.field_76767_f, Biomes.field_150583_P), 18), (int)2);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_150469_bN, Arrays.asList(Biomes.field_76768_g), 10), (int)2);
        }
    }

    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getState() != null && event.getState().func_177230_c() instanceof BlockDimensionOre) {
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            BlockDimensionOre block = (BlockDimensionOre)event.getState().func_177230_c();
            block.trySpawnTriggeredEntity(world, pos);
        }
    }

    private void registerDimensionOres() {
        int emeraldHarvest;
        int ironHarvest;
        int coalHarvest = 0;
        int lapisHarvest = ironHarvest = 1;
        int diamondHarvest = emeraldHarvest = 2;
        int goldHarvest = emeraldHarvest;
        int redstoneHarvest = emeraldHarvest;
        nether_redstone_ore = new BlockDimensionOre(Items.field_151137_ax);
        nether_redstone_ore.setPickaxeHarvestLevel(ironHarvest).setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 2);
        BlockRegistry.registerBlock((Block)nether_redstone_ore, "nether_redstone_ore");
        nether_redstone_ore.registerSmeltingOutput(Items.field_151137_ax);
        nether_iron_ore = new BlockDimensionOre(Items.field_151042_j);
        nether_iron_ore.setPickaxeHarvestLevel(ironHarvest).setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 2);
        BlockRegistry.registerBlock((Block)nether_iron_ore, "nether_iron_ore");
        nether_iron_ore.registerSmeltingOutput(Items.field_151042_j);
        nether_gold_ore = new BlockDimensionOre(Items.field_151074_bl, 0, 4);
        nether_gold_ore.setPickaxeHarvestLevel(goldHarvest).setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 1);
        BlockRegistry.registerBlock((Block)nether_gold_ore, "nether_gold_ore");
        nether_gold_ore.registerSmeltingOutput(Items.field_151043_k);
        nether_coal_ore = new BlockDimensionOre(Items.field_151044_h);
        nether_coal_ore.setPickaxeHarvestLevel(coalHarvest).setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 1);
        BlockRegistry.registerBlock((Block)nether_coal_ore, "nether_coal_ore");
        nether_coal_ore.registerSmeltingOutput(Items.field_151044_h);
        nether_lapis_ore = new BlockDimensionOre(Items.field_151100_aR, EnumDyeColor.BLUE.func_176767_b(), 3);
        nether_lapis_ore.setPickaxeHarvestLevel(lapisHarvest).setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 2);
        BlockRegistry.registerBlock((Block)nether_lapis_ore, "nether_lapis_ore");
        nether_lapis_ore.registerSmeltingOutput(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
        nether_emerald_ore = new BlockDimensionOre(Items.field_151166_bC);
        nether_emerald_ore.setPickaxeHarvestLevel(emeraldHarvest).setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 5);
        BlockRegistry.registerBlock((Block)nether_emerald_ore, "nether_emerald_ore");
        nether_emerald_ore.registerSmeltingOutput(Items.field_151166_bC);
        nether_diamond_ore = new BlockDimensionOre(Items.field_151045_i);
        nether_diamond_ore.setPickaxeHarvestLevel(diamondHarvest).setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 8);
        BlockRegistry.registerBlock((Block)nether_diamond_ore, "nether_diamond_ore");
        nether_diamond_ore.registerSmeltingOutput(Items.field_151045_i);
        end_redstone_ore = new BlockDimensionOre(Items.field_151137_ax);
        end_redstone_ore.setPickaxeHarvestLevel(redstoneHarvest).setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 3);
        BlockRegistry.registerBlock((Block)end_redstone_ore, "end_redstone_ore");
        end_redstone_ore.registerSmeltingOutput(Items.field_151137_ax);
        end_coal_ore = new BlockDimensionOre(Items.field_151044_h);
        end_coal_ore.setPickaxeHarvestLevel(coalHarvest).setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 1);
        BlockRegistry.registerBlock((Block)end_coal_ore, "end_coal_ore");
        end_coal_ore.registerSmeltingOutput(Items.field_151044_h);
        end_lapis_ore = new BlockDimensionOre(Items.field_151100_aR, EnumDyeColor.BLUE.func_176767_b(), 3);
        end_lapis_ore.setPickaxeHarvestLevel(lapisHarvest).setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 5);
        BlockRegistry.registerBlock((Block)end_lapis_ore, "end_lapis_ore");
        end_lapis_ore.registerSmeltingOutput(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
        end_emerald_ore = new BlockDimensionOre(Items.field_151166_bC);
        end_emerald_ore.setPickaxeHarvestLevel(emeraldHarvest).setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 8);
        BlockRegistry.registerBlock((Block)end_emerald_ore, "end_emerald_ore");
        end_emerald_ore.registerSmeltingOutput(Items.field_151166_bC);
        end_diamond_ore = new BlockDimensionOre(Items.field_151045_i);
        end_diamond_ore.setPickaxeHarvestLevel(diamondHarvest).setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 8);
        BlockRegistry.registerBlock((Block)end_diamond_ore, "end_diamond_ore");
        end_diamond_ore.registerSmeltingOutput(Items.field_151045_i);
        end_gold_ore = new BlockDimensionOre(Items.field_151043_k);
        end_gold_ore.setPickaxeHarvestLevel(goldHarvest).setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 2);
        BlockRegistry.registerBlock((Block)end_gold_ore, "end_gold_ore");
        end_gold_ore.registerSmeltingOutput(Items.field_151043_k);
        end_iron_ore = new BlockDimensionOre(Items.field_151042_j);
        end_iron_ore.setPickaxeHarvestLevel(ironHarvest).setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 2);
        BlockRegistry.registerBlock((Block)end_iron_ore, "end_iron_ore");
        end_iron_ore.registerSmeltingOutput(Items.field_151042_j);
    }

    static {
        oreSpawns = true;
        emeraldHeight = true;
    }
}

