/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TextInfoModule
extends BaseEventModule
implements IHasConfig {
    private boolean spawnDistanceEnabled;
    private boolean horseInfoEnabled;
    private boolean foodDetails;
    private boolean fuelDetails;

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int burnTime;
            ItemStack itemStack = event.getItemStack();
            if (itemStack == null || itemStack.func_77973_b() == null) {
                return;
            }
            if (this.foodDetails && itemStack.func_77973_b() instanceof ItemFood) {
                ItemFood food = (ItemFood)itemStack.func_77973_b();
                int hunger = food.func_150905_g(itemStack);
                float satur = food.func_150906_h(itemStack);
                if (hunger > 0 || satur > 0.0f) {
                    event.getToolTip().add(hunger + " (" + satur + ")");
                }
            }
            if (this.fuelDetails && (burnTime = TileEntityFurnace.func_145952_a((ItemStack)itemStack)) > 0) {
                event.getToolTip().add(UtilChat.lang("tooltip.burntime") + burnTime);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextOverlay(RenderGameOverlayEvent.Text event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (this.spawnDistanceEnabled && player.field_71093_bK == 0) {
            this.addSpawnInfo(event);
        }
        if (this.horseInfoEnabled) {
            this.addHorseInfo(event);
        }
    }

    private void addHorseInfo(RenderGameOverlayEvent.Text event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)player.func_184187_bx();
            double speed = UtilEntity.getSpeedTranslated(horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            double jumpHeight = UtilEntity.getJumpTranslated(horse.func_110215_cj());
            DecimalFormat df = new DecimalFormat("0.00");
            event.getLeft().add(UtilChat.lang("debug.horsespeed") + df.format(speed));
            df = new DecimalFormat("0.0");
            event.getLeft().add(UtilChat.lang("debug.horsejump") + df.format(jumpHeight));
        }
    }

    private void addSpawnInfo(RenderGameOverlayEvent.Text event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        BlockPos spawn = player.func_130014_f_().func_175694_M();
        BlockPos here = player.func_180425_c();
        Chunk chunkHere = player.func_130014_f_().func_175726_f(here);
        int xCenterOfChunk = UtilWorld.chunkToBlock(chunkHere.field_76635_g) + 8;
        int zCenterOfChunk = UtilWorld.chunkToBlock(chunkHere.field_76647_h) + 8;
        int xFromSpawn = Math.abs(xCenterOfChunk - spawn.func_177958_n());
        int zFromSpawn = Math.abs(zCenterOfChunk - spawn.func_177952_p());
        DecimalFormat df = new DecimalFormat("0.0");
        double dist = UtilWorld.distanceBetweenHorizontal(here, spawn);
        event.getLeft().add(UtilChat.lang("debug.spawn.distance") + df.format(dist));
        if (xFromSpawn < 128 && zFromSpawn < 128) {
            event.getLeft().add(TextFormatting.GREEN + UtilChat.lang("debug.spawn.chunks"));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        this.spawnDistanceEnabled = config.getBoolean("F3SpawnChunkInfo", "cyclicmagic.player", true, "Show Within Spawn Chunks or Distance from Spawn in F3 screen.");
        this.horseInfoEnabled = config.getBoolean("F3HorseInfo", "cyclicmagic.player", true, "Show Speed and jump height of any horse you are riding in F3.");
        String category = "cyclicmagic.items";
        config.addCustomCategoryComment(category, "Tweaks to new and existing items");
        this.foodDetails = config.getBoolean("Food Details", category, true, "Add food value and saturation to items info (hold shift)");
        this.fuelDetails = config.getBoolean("Fuel Details", category, true, "Add fuel burn time to items info (hold shift)");
    }
}

