/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MountedTweaksModule
extends BaseEventModule
implements IHasConfig {
    private static final String KEY_MOUNTENTITY = "CYCLIC_ENTITYID";
    private boolean showHungerMounted;
    private boolean mountedPearl;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (this.showHungerMounted) {
            GuiIngameForge.renderFood = true;
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.player";
        this.showHungerMounted = config.getBoolean("Show Hunger Mounted", category, true, "Force the players hunger bar to show even when mounted");
        this.mountedPearl = config.getBoolean("Pearls On Horseback", category, true, "Enderpearls work on a horse, bringing it with you");
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase playerRider = event.getEntityLiving();
        if (playerRider != null && playerRider instanceof EntityPlayer && playerRider.getEntityData().func_74764_b(KEY_MOUNTENTITY) && !playerRider.func_184218_aH()) {
            Entity maybeHorse;
            World world = playerRider.func_130014_f_();
            int eid = playerRider.getEntityData().func_74762_e(KEY_MOUNTENTITY);
            if (eid >= 0 && (maybeHorse = world.func_73045_a(eid)) != null && !maybeHorse.field_70128_L && playerRider.func_184205_a(maybeHorse, true)) {
                playerRider.getEntityData().func_82580_o(KEY_MOUNTENTITY);
            }
        }
    }

    @SubscribeEvent
    public void onEnderTeleportEvent(EnderTeleportEvent event) {
        Entity rider;
        if (this.mountedPearl && (rider = event.getEntity()) != null && rider instanceof EntityPlayer && rider.func_184187_bx() != null) {
            EntityPlayer playerRider = (EntityPlayer)rider;
            Entity maybeHorse = playerRider.func_184187_bx();
            event.getEntity().func_184187_bx().func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            playerRider.getEntityData().func_74768_a(KEY_MOUNTENTITY, maybeHorse.func_145782_y());
        }
    }
}

