/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.dispenser.BehaviorProjectileThrowable;
import com.lothrazar.cyclicmagic.entity.projectile.EntityBlazeBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDungeonEye;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamite;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamiteBlockSafe;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamiteMining;
import com.lothrazar.cyclicmagic.entity.projectile.EntityFishingBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityLightningballBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityMagicNetEmpty;
import com.lothrazar.cyclicmagic.entity.projectile.EntityMagicNetFull;
import com.lothrazar.cyclicmagic.entity.projectile.EntityShearingBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntitySnowballBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityTorchBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityWaterBolt;
import com.lothrazar.cyclicmagic.item.projectile.BaseItemProjectile;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileBlaze;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileDungeon;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileFishing;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileLightning;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileMagicNet;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileSnow;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileTNT;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileTorch;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileWater;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileWool;
import com.lothrazar.cyclicmagic.module.BaseModule;
import com.lothrazar.cyclicmagic.registry.EntityProjectileRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemProjectileModule
extends BaseModule
implements IHasConfig {
    private boolean enableEnderBlaze;
    private boolean enableEnderDungeonFinder;
    private boolean enderFishing;
    private boolean enderSnow;
    private boolean enderWool;
    private boolean enderTorch;
    private boolean enderWater;
    private boolean enderLightning;
    private boolean enderBombsEnabled;
    ArrayList<BaseItemProjectile> projectiles = new ArrayList();
    private boolean dynamiteSafe;
    private boolean dynamiteMining;
    private boolean magicNet;

    @Override
    public void onInit() {
        if (this.enableEnderBlaze) {
            ItemProjectileBlaze ender_blaze = new ItemProjectileBlaze();
            ItemRegistry.addItem(ender_blaze, "ender_blaze");
            EntityProjectileRegistry.registerModEntity(EntityBlazeBolt.class, "blazebolt", 1008);
            EntityBlazeBolt.renderSnowball = ender_blaze;
            this.projectiles.add(ender_blaze);
        }
        if (this.enableEnderDungeonFinder) {
            ItemProjectileDungeon ender_dungeon = new ItemProjectileDungeon();
            ItemRegistry.addItem(ender_dungeon, "ender_dungeon");
            EntityProjectileRegistry.registerModEntity(EntityDungeonEye.class, "dungeonbolt", 1006);
            EntityDungeonEye.renderSnowball = ender_dungeon;
            LootTableRegistry.registerLoot(ender_dungeon);
            ItemRegistry.registerWithJeiDescription(ender_dungeon);
            this.projectiles.add(ender_dungeon);
        }
        if (this.enderFishing) {
            ItemProjectileFishing ender_fishing = new ItemProjectileFishing();
            ItemRegistry.addItem(ender_fishing, "ender_fishing");
            EntityProjectileRegistry.registerModEntity(EntityFishingBolt.class, "fishingbolt", 1004);
            EntityFishingBolt.renderSnowball = ender_fishing;
            ItemRegistry.registerWithJeiDescription(ender_fishing);
            this.projectiles.add(ender_fishing);
        }
        if (this.enderWool) {
            ItemProjectileWool ender_wool = new ItemProjectileWool();
            ItemRegistry.addItem(ender_wool, "ender_wool");
            EntityProjectileRegistry.registerModEntity(EntityShearingBolt.class, "woolbolt", 1003);
            EntityShearingBolt.renderSnowball = ender_wool;
            ItemRegistry.registerWithJeiDescription(ender_wool);
            this.projectiles.add(ender_wool);
        }
        if (this.enderTorch) {
            ItemProjectileTorch ender_torch = new ItemProjectileTorch();
            ItemRegistry.addItem(ender_torch, "ender_torch");
            EntityProjectileRegistry.registerModEntity(EntityTorchBolt.class, "torchbolt", 1002);
            EntityTorchBolt.renderSnowball = ender_torch;
            ItemRegistry.registerWithJeiDescription(ender_torch);
            this.projectiles.add(ender_torch);
        }
        if (this.enderWater) {
            ItemProjectileWater ender_water = new ItemProjectileWater();
            ItemRegistry.addItem(ender_water, "ender_water");
            EntityProjectileRegistry.registerModEntity(EntityWaterBolt.class, "waterbolt", 1000);
            EntityWaterBolt.renderSnowball = ender_water;
            ItemRegistry.registerWithJeiDescription(ender_water);
            this.projectiles.add(ender_water);
        }
        if (this.enderSnow) {
            ItemProjectileSnow ender_snow = new ItemProjectileSnow();
            ItemRegistry.addItem(ender_snow, "ender_snow");
            EntityProjectileRegistry.registerModEntity(EntitySnowballBolt.class, "frostbolt", 1001);
            EntitySnowballBolt.renderSnowball = ender_snow;
            ItemRegistry.registerWithJeiDescription(ender_snow);
            this.projectiles.add(ender_snow);
        }
        if (this.enderLightning) {
            ItemProjectileLightning ender_lightning = new ItemProjectileLightning();
            ItemRegistry.addItem(ender_lightning, "ender_lightning");
            EntityProjectileRegistry.registerModEntity(EntityLightningballBolt.class, "lightningbolt", 999);
            EntityLightningballBolt.renderSnowball = ender_lightning;
            LootTableRegistry.registerLoot(ender_lightning);
            ItemRegistry.registerWithJeiDescription(ender_lightning);
            this.projectiles.add(ender_lightning);
        }
        if (this.dynamiteSafe) {
            ItemProjectileTNT dynamite_safe = new ItemProjectileTNT(6, ItemProjectileTNT.ExplosionType.BLOCKSAFE);
            ItemRegistry.addItem(dynamite_safe, "dynamite_safe");
            EntityProjectileRegistry.registerModEntity(EntityDynamiteBlockSafe.class, "tntblocksafebolt", 1009);
            EntityDynamiteBlockSafe.renderSnowball = dynamite_safe;
            this.projectiles.add(dynamite_safe);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)dynamite_safe, 6), (Object[])new Object[]{new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151102_aT), new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151119_aD), new ItemStack((Block)Blocks.field_150338_P), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151014_N), new ItemStack(Blocks.field_150347_e)});
        }
        if (this.magicNet) {
            ItemProjectileMagicNet magic_net = new ItemProjectileMagicNet();
            ItemRegistry.addItem(magic_net, "magic_net");
            EntityMagicNetEmpty.renderSnowball = magic_net;
            EntityMagicNetFull.renderSnowball = magic_net;
            EntityProjectileRegistry.registerModEntity(EntityMagicNetFull.class, "magicnetfull", 1011);
            EntityProjectileRegistry.registerModEntity(EntityMagicNetEmpty.class, "magicnetempty", 1012);
            this.projectiles.add(magic_net);
        }
        if (this.dynamiteMining) {
            ItemProjectileTNT dynamite_mining = new ItemProjectileTNT(6, ItemProjectileTNT.ExplosionType.MINING);
            ItemRegistry.addItem(dynamite_mining, "dynamite_mining");
            EntityProjectileRegistry.registerModEntity(EntityDynamiteMining.class, "tntminingbolt", 1010);
            EntityDynamiteMining.renderSnowball = dynamite_mining;
            this.projectiles.add(dynamite_mining);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)dynamite_mining, 6), (Object[])new Object[]{new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151119_aD), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151130_bT)});
        }
        if (this.enderBombsEnabled) {
            ItemProjectileTNT ender_tnt_1 = new ItemProjectileTNT(1, ItemProjectileTNT.ExplosionType.NORMAL);
            ItemProjectileTNT ender_tnt_2 = new ItemProjectileTNT(2, ItemProjectileTNT.ExplosionType.NORMAL);
            ItemProjectileTNT ender_tnt_3 = new ItemProjectileTNT(3, ItemProjectileTNT.ExplosionType.NORMAL);
            ItemProjectileTNT ender_tnt_4 = new ItemProjectileTNT(4, ItemProjectileTNT.ExplosionType.NORMAL);
            ItemProjectileTNT ender_tnt_5 = new ItemProjectileTNT(5, ItemProjectileTNT.ExplosionType.NORMAL);
            ItemProjectileTNT ender_tnt_6 = new ItemProjectileTNT(6, ItemProjectileTNT.ExplosionType.NORMAL);
            ItemRegistry.addItem(ender_tnt_1, "ender_tnt_1");
            ItemRegistry.addItem(ender_tnt_2, "ender_tnt_2");
            ItemRegistry.addItem(ender_tnt_3, "ender_tnt_3");
            ItemRegistry.addItem(ender_tnt_4, "ender_tnt_4");
            ItemRegistry.addItem(ender_tnt_5, "ender_tnt_5");
            ItemRegistry.addItem(ender_tnt_6, "ender_tnt_6");
            EntityProjectileRegistry.registerModEntity(EntityDynamite.class, "tntbolt", 1007);
            EntityDynamite.renderSnowball = ender_tnt_1;
            this.projectiles.add(ender_tnt_1);
            this.projectiles.add(ender_tnt_2);
            this.projectiles.add(ender_tnt_3);
            this.projectiles.add(ender_tnt_4);
            this.projectiles.add(ender_tnt_5);
            this.projectiles.add(ender_tnt_6);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_1, 12), (Object[])new Object[]{new ItemStack(Blocks.field_150335_W), new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151119_aD), new ItemStack(Items.field_151079_bi)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_2), (Object[])new Object[]{new ItemStack((Item)ender_tnt_1), new ItemStack((Item)ender_tnt_1), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_3), (Object[])new Object[]{new ItemStack((Item)ender_tnt_2), new ItemStack((Item)ender_tnt_2), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_4), (Object[])new Object[]{new ItemStack((Item)ender_tnt_3), new ItemStack((Item)ender_tnt_3), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_5), (Object[])new Object[]{new ItemStack((Item)ender_tnt_4), new ItemStack((Item)ender_tnt_4), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_6), (Object[])new Object[]{new ItemStack((Item)ender_tnt_5), new ItemStack((Item)ender_tnt_5), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_3), (Object[])new Object[]{new ItemStack((Item)ender_tnt_1), new ItemStack((Item)ender_tnt_1), new ItemStack((Item)ender_tnt_1), new ItemStack((Item)ender_tnt_1), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_4), (Object[])new Object[]{new ItemStack((Item)ender_tnt_2), new ItemStack((Item)ender_tnt_2), new ItemStack((Item)ender_tnt_2), new ItemStack((Item)ender_tnt_2), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_5), (Object[])new Object[]{new ItemStack((Item)ender_tnt_3), new ItemStack((Item)ender_tnt_3), new ItemStack((Item)ender_tnt_3), new ItemStack((Item)ender_tnt_3), new ItemStack(Items.field_151119_aD)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ender_tnt_6), (Object[])new Object[]{new ItemStack((Item)ender_tnt_4), new ItemStack((Item)ender_tnt_4), new ItemStack((Item)ender_tnt_4), new ItemStack((Item)ender_tnt_4), new ItemStack(Items.field_151119_aD)});
            LootTableRegistry.registerLoot(ender_tnt_6);
        }
    }

    @Override
    public void onPostInit() {
        for (BaseItemProjectile item : this.projectiles) {
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)new BehaviorProjectileThrowable(item));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        this.magicNet = config.getBoolean("MonsterBall", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.dynamiteSafe = config.getBoolean("DynamiteSafe", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.dynamiteMining = config.getBoolean("DynamiteMining", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableEnderBlaze = config.getBoolean("EnderBlaze", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enableEnderDungeonFinder = config.getBoolean("EnderDungeonFinder", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enderFishing = config.getBoolean("EnderFishing", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enderSnow = config.getBoolean("EnderSnow", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enderWool = config.getBoolean("EnderWool", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enderTorch = config.getBoolean("EnderTorch", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enderLightning = config.getBoolean("EnderLightning", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enderWater = config.getBoolean("EnderWater", "cyclicmagic.content", true, "Set false to delete - requires restart");
        this.enderBombsEnabled = config.getBoolean("EnderBombs", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }
}

