/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnvironmentTweaksModule
extends BaseEventModule
implements IHasConfig {
    private boolean saplingDespawnGrow;
    private boolean spawnersUnbreakable;
    private boolean skelLightning;
    private boolean zombLightning;

    @Override
    public void onInit() {
        this.updateHardness();
    }

    private void updateHardness() {
        if (this.spawnersUnbreakable) {
            Blocks.field_150474_ac.func_149722_s();
        } else {
            Blocks.field_150474_ac.func_149711_c(5.0f);
        }
    }

    @SubscribeEvent
    public void onItemExpireEvent(ItemExpireEvent event) {
        if (this.saplingDespawnGrow) {
            EntityItem entityItem = event.getEntityItem();
            Entity entity = event.getEntity();
            ItemStack is = entityItem.func_92059_d();
            World world = entity.func_130014_f_();
            if (is == null) {
                return;
            }
            Block blockhere = entity.func_130014_f_().func_180495_p(entityItem.func_180425_c()).func_177230_c();
            Block blockdown = entity.func_130014_f_().func_180495_p(entityItem.func_180425_c().func_177977_b()).func_177230_c();
            if (blockhere == Blocks.field_150350_a && blockdown == Blocks.field_150346_d || blockdown == Blocks.field_150349_c) {
                if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150345_g) {
                    world.func_175656_a(entityItem.func_180425_c(), UtilItemStack.getStateFromMeta(Blocks.field_150345_g, is.func_77952_i()));
                } else if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150337_Q) {
                    world.func_175656_a(entityItem.func_180425_c(), Blocks.field_150337_Q.func_176223_P());
                } else if (Block.func_149634_a((Item)is.func_77973_b()) == Blocks.field_150338_P) {
                    world.func_175656_a(entityItem.func_180425_c(), Blocks.field_150338_P.func_176223_P());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        EntityZombie zomb;
        EntitySkeleton skel;
        if (this.skelLightning && event.getEntity() instanceof EntitySkeleton && event.getLightning() != null && (skel = (EntitySkeleton)event.getEntity()).func_189771_df() == SkeletonType.NORMAL) {
            SkeletonType newType = skel.func_130014_f_().field_73012_v.nextDouble() > 0.5 ? SkeletonType.WITHER : SkeletonType.STRAY;
            skel.func_189768_a(newType);
            skel.func_70691_i(skel.func_110138_aP());
        }
        if (this.zombLightning && event.getEntity() instanceof EntityZombie && event.getLightning() != null && (zomb = (EntityZombie)event.getEntity()).func_189777_di() == ZombieType.NORMAL) {
            zomb.func_189778_a(ZombieType.HUSK);
            zomb.func_70691_i(zomb.func_110138_aP());
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        this.skelLightning = config.getBoolean("LightningSkeletonMutate", "cyclicmagic.mobs", true, "Skeletons turn into either a Stray or a Wither Skeleton when hit by lightning");
        this.zombLightning = config.getBoolean("LightningZombieMutate", "cyclicmagic.mobs", true, "Zombies turn into a Husk when hit by lightning");
        String category = "cyclicmagic.blocks";
        this.saplingDespawnGrow = config.getBoolean("Plant Despawning Saplings", category, true, "Plant saplings (and mushrooms) if they despawn on grass/dirt");
        this.spawnersUnbreakable = config.getBoolean("Spawners Unbreakable", category, false, "Make mob spawners unbreakable");
        this.updateHardness();
    }
}

