/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.tool;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.BaseTool;
import com.lothrazar.cyclicmagic.util.UtilHarvestCrops;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemToolHarvest
extends BaseTool
implements IHasRecipe {
    private static final int range = 6;
    private static final int durability = 1000;
    private UtilHarvestCrops.HarestCropsConfig conf;
    private HarvestType harvestType;

    public ItemToolHarvest(HarvestType c) {
        super(1000);
        this.harvestType = c;
        this.conf = new UtilHarvestCrops.HarestCropsConfig();
        switch (this.harvestType) {
            case CROPS: {
                this.conf.doesPumpkinBlocks = true;
                this.conf.doesMelonBlocks = true;
                this.conf.doesCrops = true;
                this.conf.doesCactus = true;
                this.conf.doesReeds = true;
                break;
            }
            case WEEDS: {
                this.conf.doesFlowers = true;
                this.conf.doesMushroom = true;
                this.conf.doesTallgrass = true;
                this.conf.doesSapling = true;
                break;
            }
            case LEAVES: {
                this.conf.doesLeaves = true;
                break;
            }
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World worldObj, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos offset = pos;
        if (side != null) {
            offset = pos.func_177972_a(side);
        }
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177977_b().func_177977_b(), 4, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177977_b(), 4, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset, 6, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177984_a(), 4, this.conf);
        UtilHarvestCrops.harvestArea(worldObj, offset.func_177984_a().func_177984_a(), 4, this.conf);
        super.onUse(stack, player, worldObj, hand);
        return super.func_180614_a(stack, player, worldObj, offset, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void addRecipe() {
        switch (this.harvestType) {
            case CROPS: {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{" gs", " bg", "b  ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), Items.field_151128_bU, Character.valueOf('s'), Items.field_151018_J});
                break;
            }
            case LEAVES: {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{" gs", " bg", "b  ", Character.valueOf('b'), Items.field_151055_y, Character.valueOf('g'), Items.field_151007_F, Character.valueOf('s'), Items.field_151049_t});
                break;
            }
            case WEEDS: {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{" gs", " bg", "b  ", Character.valueOf('b'), Items.field_151055_y, Character.valueOf('g'), Items.field_151007_F, Character.valueOf('s'), Items.field_151018_J});
                break;
            }
        }
    }

    public static enum HarvestType {
        WEEDS,
        LEAVES,
        CROPS;

    }
}

