/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.gear;

import com.lothrazar.cyclicmagic.ICanToggleOnOff;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemPowerArmor
extends ItemArmor
implements IHasRecipe,
ICanToggleOnOff {
    private static final float SNEAKSPEED = 0.077f;
    public static final String NBT_GLOW = "cyclicmagic_glow";
    public static final String NBT_STEP = "cyclicmagic_step";
    private static final String NBT_STATUS = "onoff";

    public ItemPowerArmor(ItemArmor.ArmorMaterial material, EntityEquipmentSlot armorType) {
        super(material, 0, armorType);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        boolean isTurnedOn = this.isOn(itemStack);
        switch (this.field_77881_a) {
            case CHEST: {
                if (!isTurnedOn) break;
                this.setSneakspeed(player);
                break;
            }
            case FEET: {
                if (!isTurnedOn) break;
                this.setLiquidWalk(world, player);
                break;
            }
            case HEAD: {
                ItemPowerArmor.setGlowing(player, isTurnedOn);
                if (!isTurnedOn) break;
                this.setNightVision(player);
                break;
            }
            case LEGS: {
                ItemPowerArmor.setStepHeight(player, isTurnedOn);
            }
        }
    }

    private void setNightVision(EntityPlayer player) {
        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 400, 0));
    }

    private void setSneakspeed(EntityPlayer player) {
        if (player.func_70093_af() && player.field_70701_bs > 0.0f) {
            UtilEntity.speedupEntity((EntityLivingBase)player, 0.077f);
        }
    }

    private void setLiquidWalk(World world, EntityPlayer player) {
        BlockPos belowPos = player.func_180425_c().func_177977_b();
        if (world.func_72953_d(new AxisAlignedBB(belowPos)) && world.func_175623_d(player.func_180425_c()) && player.field_70181_x < 0.0 && !player.func_70093_af()) {
            player.field_70181_x = 0.0;
            player.field_70122_E = true;
        }
    }

    public static void setStepHeight(EntityPlayer player, boolean on) {
        player.field_70138_W = on ? 1.0f : 0.5f;
        player.getEntityData().func_74757_a(NBT_STEP, on);
    }

    public static void checkIfLegsOff(EntityPlayer player) {
        Item itemInSlot = UtilPlayer.getItemArmorSlot(player, EntityEquipmentSlot.LEGS);
        if (player.getEntityData().func_74767_n(NBT_STEP) && (itemInSlot == null || !(itemInSlot instanceof ItemPowerArmor))) {
            ItemPowerArmor.setStepHeight(player, false);
        }
    }

    public static void checkIfHelmOff(EntityPlayer player) {
        Item itemInSlot = UtilPlayer.getItemArmorSlot(player, EntityEquipmentSlot.HEAD);
        if (player.getEntityData().func_74767_n(NBT_GLOW) && (itemInSlot == null || !(itemInSlot instanceof ItemPowerArmor))) {
            ItemPowerArmor.setGlowing(player, false);
        }
    }

    public static void setGlowing(EntityPlayer player, boolean hidden) {
        player.func_184195_f(hidden);
        player.getEntityData().func_74757_a(NBT_GLOW, hidden);
    }

    public void func_77624_a(ItemStack held, EntityPlayer player, List<String> list, boolean par4) {
        list.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
        String onoff = this.isOn(held) ? "on" : "off";
        list.add(UtilChat.lang("item.cantoggle.tooltip.info") + UtilChat.lang("item.cantoggle.tooltip." + onoff));
    }

    @Override
    public void addRecipe() {
        switch (this.field_77881_a) {
            case CHEST: {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"p p", "oio", "ooo", Character.valueOf('i'), new ItemStack((Item)Items.field_151023_V, 1, Short.MAX_VALUE), Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('p'), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.PURPLE.func_176767_b())});
                break;
            }
            case FEET: {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"   ", "p p", "oio", Character.valueOf('i'), new ItemStack((Item)Items.field_151029_X, 1, Short.MAX_VALUE), Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('p'), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.PURPLE.func_176767_b())});
                break;
            }
            case HEAD: {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"oio", "p p", "   ", Character.valueOf('i'), new ItemStack((Item)Items.field_151020_U, 1, Short.MAX_VALUE), Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('p'), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.PURPLE.func_176767_b())});
                break;
            }
            case LEGS: {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"oio", "p p", "o o", Character.valueOf('i'), new ItemStack((Item)Items.field_151022_W, 1, Short.MAX_VALUE), Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('p'), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.PURPLE.func_176767_b())});
            }
        }
    }

    @Override
    public void toggleOnOff(ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        int vnew = this.isOn(held) ? 0 : 1;
        tags.func_74768_a(NBT_STATUS, vnew);
    }

    @Override
    public boolean isOn(ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(NBT_STATUS)) {
            return true;
        }
        return tags.func_74762_e(NBT_STATUS) == 1;
    }
}

