/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.item.ItemChestSackEmpty;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChestSack
extends BaseItem {
    public static final String name = "chest_sack";
    public static final String KEY_BLOCKID = "block";
    public static final String KEY_BLOCKTILE = "tile";
    public static final String KEY_BLOCKNAME = "blockname";
    public static final String KEY_BLOCKSTATE = "blockstate";
    private Item emptySack;

    public ItemChestSack() {
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos offset = pos.func_177972_a(side);
        if (!worldIn.func_175623_d(offset)) {
            return EnumActionResult.FAIL;
        }
        if (this.createAndFillChest(playerIn, stack, offset)) {
            playerIn.func_184611_a(hand, null);
            UtilSound.playSound(playerIn, pos, SoundRegistry.thunk);
            if (!playerIn.field_71075_bZ.field_75098_d && this.emptySack != null) {
                UtilItemStack.dropItemStackInWorld(worldIn, playerIn.func_180425_c(), this.emptySack);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean createAndFillChest(EntityPlayer entityPlayer, ItemStack heldChestSack, BlockPos pos) {
        NBTTagCompound itemData = UtilNBT.getItemStackNBT(heldChestSack);
        Block block = Block.func_149729_e((int)itemData.func_74762_e(KEY_BLOCKID));
        if (block == null) {
            heldChestSack.field_77994_a = 0;
            UtilChat.addChatMessage(entityPlayer, "Invalid block id " + itemData.func_74762_e(KEY_BLOCKID));
            return false;
        }
        IBlockState toPlace = itemData.func_74764_b(KEY_BLOCKSTATE) ? UtilItemStack.getStateFromMeta(block, itemData.func_74762_e(KEY_BLOCKSTATE)) : block.func_176223_P();
        World world = entityPlayer.func_130014_f_();
        world.func_175656_a(pos, toPlace);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            NBTTagCompound tileData = itemData.func_74775_l(KEY_BLOCKTILE);
            tileData.func_74768_a("x", pos.func_177958_n());
            tileData.func_74768_a("y", pos.func_177956_o());
            tileData.func_74768_a("z", pos.func_177952_p());
            tile.func_145839_a(tileData);
            tile.func_70296_d();
            world.func_175646_b(pos, tile);
        }
        heldChestSack.field_77994_a = 0;
        heldChestSack.func_77982_d(null);
        return true;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean advanced) {
        String blockname;
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(KEY_BLOCKNAME) && (blockname = itemStack.func_77978_p().func_74779_i(KEY_BLOCKNAME)) != null && blockname.length() > 0) {
            list.add(UtilChat.lang(blockname + ".name"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void setEmptySack(ItemChestSackEmpty item) {
        this.emptySack = item;
    }
}

