/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.mtlib.helpers;

import com.blamejared.mtlib.helpers.LogHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import minetweaker.api.entity.IEntity;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.mc1102.item.MCItemStack;
import minetweaker.mc1102.liquid.MCLiquidStack;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class InputHelper {
    public static boolean isABlock(IItemStack block) {
        return InputHelper.isABlock(InputHelper.toStack(block));
    }

    public static <T> T[][] getMultiDimensionalArray(Class<T> clazz, T[] array, int height, int width) {
        Object[][] multiDim = (Object[][])Array.newInstance(clazz, height, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                multiDim[y][x] = array[x + y * width];
            }
        }
        return multiDim;
    }

    public static IItemStack[] toStacks(IIngredient[] iIngredient) {
        ArrayList<IItemStack> stacks = new ArrayList<IItemStack>();
        for (IIngredient ing : iIngredient) {
            for (IItemStack stack : ing.getItems()) {
                stacks.add(stack);
            }
        }
        return stacks.toArray(new IItemStack[stacks.size()]);
    }

    public static boolean isABlock(ItemStack block) {
        return block.func_77973_b() instanceof ItemBlock;
    }

    public static Entity toEntity(IEntity iEntity) {
        return null;
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            LogHelper.logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static IIngredient toIngredient(ItemStack stack) {
        return InputHelper.toIItemStack(stack);
    }

    public static IIngredient toIngredient(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return new MCLiquidStack(stack);
    }

    public static IItemStack toIItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return new MCItemStack(stack);
    }

    public static ILiquidStack toILiquidStack(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return new MCLiquidStack(stack);
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = InputHelper.toStack(iStack[i]);
        }
        return output;
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return InputHelper.toString((IOreDictEntry)iStack);
        }
        if (iStack instanceof IItemStack) {
            return InputHelper.toStack((IItemStack)iStack);
        }
        return null;
    }

    public static Object[] toObjects(IIngredient[] ingredient) {
        if (ingredient == null) {
            return null;
        }
        Object[] output = new Object[ingredient.length];
        for (int i = 0; i < ingredient.length; ++i) {
            output[i] = ingredient[i] != null ? InputHelper.toObject(ingredient[i]) : "";
        }
        return output;
    }

    public static Object[] toShapedObjects(IIngredient[][] ingredients) {
        if (ingredients == null) {
            return null;
        }
        ArrayList<Object> prep = new ArrayList<Object>();
        prep.add("abc");
        prep.add("def");
        prep.add("ghi");
        char[][] map = new char[][]{{'a', 'b', 'c'}, {'d', 'e', 'f'}, {'g', 'h', 'i'}};
        for (int x = 0; x < ingredients.length; ++x) {
            if (ingredients[x] == null) continue;
            for (int y = 0; y < ingredients[x].length; ++y) {
                if (ingredients[x][y] == null || x >= map.length || y >= map[x].length) continue;
                prep.add(Character.valueOf(map[x][y]));
                prep.add(InputHelper.toObject(ingredients[x][y]));
            }
        }
        return prep.toArray();
    }

    public static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    public static FluidStack toFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluidStack((String)iStack.getName(), (int)iStack.getAmount());
    }

    public static Fluid getFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluid((String)iStack.getName());
    }

    public static FluidStack[] toFluids(IIngredient[] input) {
        return InputHelper.toFluids((IIngredient[])((IItemStack[])input));
    }

    public static FluidStack[] toFluids(ILiquidStack[] iStack) {
        FluidStack[] stack = new FluidStack[iStack.length];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = InputHelper.toFluid(iStack[i]);
        }
        return stack;
    }
}

