/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tools;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackTools {
    @Nullable
    public static ItemStack incStackSize(@Nonnull ItemStack stack, int amount) {
        stack.field_77994_a += amount;
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    @Nullable
    public static ItemStack safeCopy(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        if (stack.field_77994_a == 0) {
            stack.field_77994_a = 1;
        }
        return stack;
    }

    public static int getStackSize(@Nullable ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        return stack.field_77994_a;
    }

    @Nullable
    public static ItemStack setStackSize(@Nonnull ItemStack stack, int amount) {
        if (amount <= 0) {
            stack.field_77994_a = 0;
            return null;
        }
        stack.field_77994_a = amount;
        return stack;
    }

    public static boolean isValid(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.field_77994_a > 0;
    }

    public static boolean isEmpty(@Nullable ItemStack stack) {
        if (stack == null) {
            return true;
        }
        return stack.field_77994_a <= 0;
    }

    public static void makeEmpty(@Nonnull ItemStack stack) {
        stack.field_77994_a = 0;
    }

    @Nullable
    public static ItemStack loadFromNBT(@Nonnull NBTTagCompound nbt) {
        return ItemStack.func_77949_a((NBTTagCompound)nbt);
    }

    @Nullable
    public static ItemStack getEmptyStack() {
        return null;
    }

    @Nullable
    public static ItemStack extractItem(@Nullable TileEntity tileEntity, int slot, int amount) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.extractItem(slot, amount, false);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70298_a(slot, amount);
        }
        return ItemStackTools.getEmptyStack();
    }

    @Nullable
    public static ItemStack getStack(@Nullable TileEntity tileEntity, int slot) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return capability.getStackInSlot(slot);
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            return inventory.func_70301_a(slot);
        }
        return ItemStackTools.getEmptyStack();
    }

    public static void setStack(@Nullable TileEntity tileEntity, int slot, @Nullable ItemStack stack) {
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler capability = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.extractItem(slot, 64, false);
            if (stack != null) {
                capability.insertItem(slot, stack, false);
            }
        } else if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            inventory.func_70299_a(slot, stack);
        }
    }

    public static List<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name);
    }

    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)name, (boolean)alwaysCreateEntry);
    }
}

