/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter;

import com.google.common.collect.Maps;
import cubex2.mods.chesttransporter.CommonProxy;
import cubex2.mods.chesttransporter.ItemChestTransporter;
import cubex2.mods.chesttransporter.TransporterType;
import cubex2.mods.chesttransporter.chests.BasicDrawer;
import cubex2.mods.chesttransporter.chests.BiblioFramedChest;
import cubex2.mods.chesttransporter.chests.ChestRegistry;
import cubex2.mods.chesttransporter.chests.CompDrawer;
import cubex2.mods.chesttransporter.chests.CompactChest;
import cubex2.mods.chesttransporter.chests.QuarkChest;
import cubex2.mods.chesttransporter.chests.Spawner;
import cubex2.mods.chesttransporter.chests.TransportableChest;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="ChestTransporter", name="Chest Transporter", version="2.5.9", acceptedMinecraftVersions="[1.10.2]")
public class ChestTransporter {
    @Mod.Instance(value="ChestTransporter")
    public static ChestTransporter instance;
    @SidedProxy(clientSide="cubex2.mods.chesttransporter.ClientProxy", serverSide="cubex2.mods.chesttransporter.CommonProxy")
    public static CommonProxy proxy;
    private static boolean pickupSpawners;
    public static final EnumMap<TransporterType, ItemChestTransporter> items;
    public static final EnumMap<TransporterType, Boolean> canUseSpawner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            pickupSpawners = config.getBoolean("pickupSpawners", "general", true, "Set this to false to prevent picking up of mob spawners");
            for (TransporterType type : TransporterType.values()) {
                canUseSpawner.put(type, config.getBoolean(type.spawnerConfigName(), "general", true, "Set this to false to prevent the " + type.name().toLowerCase() + " transporter to pick up mob spawners"));
            }
        }
        finally {
            config.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (TransporterType type : TransporterType.values()) {
            ItemChestTransporter item = new ItemChestTransporter(type);
            items.put(type, item);
            item.setRegistryName("chesttransporter", "chesttransporter" + type.nameSuffix);
            GameRegistry.register((IForgeRegistryEntry)item);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)item), new Object[]{"S S", "SSS", " M ", Character.valueOf('S'), "stickWood", Character.valueOf('M'), type.recipeMaterial}));
        }
        proxy.registerModels();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        String[] classNames;
        int i;
        String[] names;
        Block block;
        TransportableChest chest = new TransportableChest((Block)Blocks.field_150486_ae, -1, 1, "vanilla");
        ChestRegistry.register(chest);
        ChestRegistry.registerMinecart(EntityMinecartChest.class, chest);
        ChestRegistry.register(new TransportableChest(Blocks.field_150447_bR, -1, 2, "vanilla_trapped"));
        if (Loader.isModLoaded((String)"ironchest") && (block = Block.func_149684_b((String)"ironchest:BlockIronChest")) != null && block != Blocks.field_150350_a) {
            names = new String[]{"iron", "gold", "diamond", "copper", "tin", "crystal", "obsidian"};
            for (i = 0; i < 7; ++i) {
                ChestRegistry.register(new TransportableChest(block, i, 3 + i, names[i]));
            }
        }
        if (Loader.isModLoaded((String)"MultiPageChest") && (block = Block.func_149684_b((String)"MultiPageChest:multipagechest")) != null && block != Blocks.field_150350_a) {
            ChestRegistry.register(new TransportableChest(block, -1, 10, "multipagechest"));
        }
        if (Loader.isModLoaded((String)"compactstorage") && (block = Block.func_149684_b((String)"compactstorage:compactChest")) != null && block != Blocks.field_150350_a) {
            ChestRegistry.register(new CompactChest(block, -1, 14, "compact_chest"));
        }
        if (Loader.isModLoaded((String)"StorageDrawers")) {
            block = Block.func_149684_b((String)"storagedrawers:basicDrawers");
            if (block != null && block != Blocks.field_150350_a) {
                names = new String[]{"full1", "full2", "full4", "half2", "half4"};
                for (i = 0; i < names.length; ++i) {
                    int dv = 19 + i;
                    if (dv == 23) {
                        dv = 27;
                    }
                    ChestRegistry.register(new BasicDrawer(block, i, dv, "basic_drawer_" + names[i]));
                }
            }
            if ((block = Block.func_149684_b((String)"storagedrawers:compDrawers")) != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new CompDrawer(block, 0, 23, "comp_drawer"));
            }
        }
        if (pickupSpawners) {
            ChestRegistry.register(new Spawner(Blocks.field_150474_ac, -1, 24, "spawner"));
        }
        if (Loader.isModLoaded((String)"Quark")) {
            block = Block.func_149684_b((String)"quark:custom_chest");
            if (block != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new QuarkChest(block, 25, "quark_chest"));
            }
            if ((block = Block.func_149684_b((String)"quark:custom_chest_trap")) != null && block != Blocks.field_150350_a) {
                ChestRegistry.register(new QuarkChest(block, 26, "quark_chest"));
            }
        }
        if (Loader.isModLoaded((String)"fluidity") && (block = Block.func_149684_b((String)"fluidity:fluidity_iron_chest")) != null && block != Blocks.field_150350_a) {
            names = new String[]{"bronze", "invar", "electrum", "tin", "brass", "lead", "steel", "nickel", "cold_iron", "adamantine", "aquarium", "mithril", "star_steel", "cupronickel", "platinum"};
            for (i = 0; i < names.length; ++i) {
                ChestRegistry.register(new TransportableChest(block, i, 28 + i, "fluidity_" + names[i]));
            }
        }
        if (Loader.isModLoaded((String)"BiblioCraft") && (block = Block.func_149684_b((String)"BiblioCraft:FramedChest")) != null && block != Blocks.field_150350_a) {
            names = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "framed"};
            for (i = 0; i < names.length; ++i) {
                TransportableChest chest1 = i == names.length - 1 ? new BiblioFramedChest(block, i, 43 + i, "biblio_chest_" + names[i]) : new TransportableChest(block, i, 43 + i, "biblio_chest_" + names[i]);
                ChestRegistry.register(chest1);
            }
        }
        if (Loader.isModLoaded((String)"ironchestminecarts") && Loader.isModLoaded((String)"ironchest")) {
            classNames = new String[]{"ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartIronChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartGoldChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartDiamondChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartCopperChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartSilverChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartCrystalChest", "ganymedes01.ironchestminecarts.minecarts.types.EntityMinecartObsidianChest"};
            try {
                for (int i2 = 0; i2 < 7; ++i2) {
                    ChestRegistry.registerMinecart(Class.forName(classNames[i2]), ChestRegistry.dvToChest.get(3 + i2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"extracarts") && Loader.isModLoaded((String)"ironchest")) {
            classNames = new String[]{"com.dta.extracarts.mods.ironchest.entities.EntityIronChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityGoldChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityDiamondChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityCopperChestCart", "com.dta.extracarts.mods.ironchest.entities.EntitySilverChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityCrystalChestCart", "com.dta.extracarts.mods.ironchest.entities.EntityObsidianChestCart"};
            try {
                for (int i3 = 0; i3 < 7; ++i3) {
                    ChestRegistry.registerMinecart(Class.forName(classNames[i3]), ChestRegistry.dvToChest.get(3 + i3));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        pickupSpawners = true;
        items = Maps.newEnumMap(TransporterType.class);
        canUseSpawner = Maps.newEnumMap(TransporterType.class);
    }
}

