/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.minecraft;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import java.lang.reflect.Field;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class HandleItemStackArray
implements IHandler<ItemStack[]> {
    @Override
    public boolean canHandle(Class<?> clazz) {
        return ItemStack[].class.isAssignableFrom(clazz);
    }

    @Override
    public boolean store(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nonnull String name, @Nonnull ItemStack[] object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("size", object.length);
        for (int i = 0; i < object.length; ++i) {
            ItemStack itemStack = object[i];
            if (itemStack == null) continue;
            NBTTagCompound subtag = new NBTTagCompound();
            itemStack.func_77955_b(subtag);
            tag.func_74782_a(i + "", (NBTBase)subtag);
        }
        nbt.func_74782_a(name, (NBTBase)tag);
        return true;
    }

    @Override
    public ItemStack[] read(@Nonnull Registry registry, @Nonnull Set<Store.StoreFor> phase, @Nonnull NBTTagCompound nbt, @Nullable Field field, @Nonnull String name, @Nullable ItemStack[] object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            int size = tag.func_74762_e("size");
            if (object == null || object.length != size) {
                object = new ItemStack[size];
            }
            for (int i = 0; i < object.length; ++i) {
                object[i] = tag.func_74764_b(i + "") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(i + "")) : null;
            }
        }
        return object;
    }
}

