/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.spawner.SpawnerNotification;
import crazypants.enderio.machine.spawner.TilePoweredSpawner;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNotification
extends MessageTileEntity<TilePoweredSpawner>
implements IMessageHandler<PacketUpdateNotification, IMessage> {
    private Set<SpawnerNotification> notification;

    public PacketUpdateNotification() {
    }

    public PacketUpdateNotification(TilePoweredSpawner tile, Set<SpawnerNotification> notification) {
        super((TileEntity)tile);
        this.notification = notification;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.notification = EnumSet.noneOf(SpawnerNotification.class);
        int count = buf.readByte();
        for (int i = 0; i < count; ++i) {
            this.notification.add(SpawnerNotification.values()[buf.readByte()]);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.notification.size());
        for (SpawnerNotification farmNotification : this.notification) {
            buf.writeByte(farmNotification.ordinal());
        }
    }

    public IMessage onMessage(PacketUpdateNotification message, MessageContext ctx) {
        TilePoweredSpawner te = (TilePoweredSpawner)message.getTileEntity(EnderIO.proxy.getClientWorld());
        if (te != null) {
            te.replaceNotification(message.notification);
        }
        return null;
    }
}

