/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedSlab;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.BasicPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.paint.render.PaintRegistry;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderPart;
import crazypants.enderio.render.property.IOMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.render.util.QuadCollector;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.NotImplementedException;

public abstract class BlockPaintedSlab
extends BlockSlab
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
IRenderMapper.IItemRenderMapper.IItemModelMapper {
    private final Block halfVariant;

    public static BlockPaintedSlab[] create() {
        BlockPaintedHalfSlab woodHalfSlab = new BlockPaintedHalfSlab(Material.field_151575_d, ModObject.blockPaintedSlab.getUnlocalisedName(), SoundType.field_185848_a);
        woodHalfSlab.func_149711_c(2.0f).func_149752_b(5.0f);
        woodHalfSlab.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedHalfSlab>(woodHalfSlab, new Block[]{Blocks.field_150376_bx}));
        BlockPaintedDoubleSlab woodDoubleSlab = new BlockPaintedDoubleSlab(Material.field_151575_d, ModObject.blockPaintedDoubleSlab.getUnlocalisedName(), (Block)woodHalfSlab, SoundType.field_185848_a);
        woodDoubleSlab.func_149711_c(2.0f).func_149752_b(5.0f);
        woodDoubleSlab.init();
        GameRegistry.register((IForgeRegistryEntry)new BlockItemPaintedSlab(woodHalfSlab, woodDoubleSlab, ModObject.blockPaintedSlab.getUnlocalisedName()));
        BlockPaintedHalfSlab rockHalfSlab = new BlockPaintedHalfSlab(Material.field_151576_e, ModObject.blockPaintedStoneSlab.getUnlocalisedName(), SoundType.field_185848_a);
        rockHalfSlab.func_149711_c(2.0f).func_149752_b(5.0f);
        rockHalfSlab.init();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedHalfSlab>(rockHalfSlab, new Block[]{Blocks.field_150333_U, Blocks.field_150333_U}));
        BlockPaintedDoubleSlab rockDoubleSlab = new BlockPaintedDoubleSlab(Material.field_151576_e, ModObject.blockPaintedStoneDoubleSlab.getUnlocalisedName(), (Block)rockHalfSlab, SoundType.field_185848_a);
        rockDoubleSlab.func_149711_c(2.0f).func_149752_b(5.0f);
        rockDoubleSlab.init();
        GameRegistry.register((IForgeRegistryEntry)new BlockItemPaintedSlab(rockHalfSlab, rockDoubleSlab, ModObject.blockPaintedStoneSlab.getUnlocalisedName()));
        GameRegistry.registerTileEntity(TileEntityPaintedBlock.TileEntityTwicePaintedBlock.class, (String)(ModObject.blockPaintedSlab.getUnlocalisedName() + "TileEntity"));
        return new BlockPaintedSlab[]{woodHalfSlab, woodDoubleSlab, rockHalfSlab, rockDoubleSlab};
    }

    public BlockPaintedSlab(Material material, String name, Block halfVariant) {
        super(material);
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate);
        this.func_149647_a(null);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.halfVariant = halfVariant != null ? halfVariant : this;
        this.field_149783_u = true;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("slab_lo", new ResourceLocation("minecraft", "block/half_slab_stone"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("slab_hi", new ResourceLocation("minecraft", "block/upper_slab_stone"), PaintRegistry.PaintMode.ALL_TEXTURES);
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        throw new NotImplementedException("This method is only used by ItemSlab for vanilla slabs.");
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock.TileEntityTwicePaintedBlock();
    }

    public String func_150002_b(int meta) {
        return this.func_149739_a();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean removedByPlayer(IBlockState bs, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(bs, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        boolean first = true;
        for (ItemStack drop : drops) {
            if (first || !this.func_176552_j()) {
                PainterUtil2.setSourceBlock(drop, this.getPaintSource(state, world, pos));
                first = false;
                continue;
            }
            PainterUtil2.setSourceBlock(drop, this.getPaintSource2(state, world, pos));
        }
        return drops;
    }

    public ItemStack getPickBlock(IBlockState bs, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(bs, target, world, pos, player);
        if (!this.func_176552_j()) {
            PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        } else if (target.field_72307_f.field_72448_b - (double)((int)target.field_72307_f.field_72448_b) > 0.5) {
            PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource2(null, (IBlockAccess)world, pos));
        } else {
            PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        }
        return pickBlock;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.halfVariant);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this.halfVariant));
    }

    public IProperty<?> func_176551_l() {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        if (this.func_176552_j()) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int func_176201_c(IBlockState state) {
        if (this.func_176552_j()) {
            return 0;
        }
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[0]) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a});
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    public void setPaintSource2(IBlockState state, IBlockAccess world, BlockPos pos, IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPaintedBlock.TileEntityTwicePaintedBlock) {
            ((TileEntityPaintedBlock.TileEntityTwicePaintedBlock)te).setPaintSource2(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    public IBlockState getPaintSource2(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.func_176552_j()) {
            TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
            if (te instanceof TileEntityPaintedBlock.TileEntityTwicePaintedBlock) {
                return ((TileEntityPaintedBlock.TileEntityTwicePaintedBlock)te).getPaintSource2();
            }
            return null;
        }
        return this.getPaintSource(state, world, pos);
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
            if (this.func_176552_j()) {
                blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(this.getPaintSource2(state, world, pos));
            } else {
                blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(state.func_177229_b((IProperty)field_176554_a));
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(Block block, ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBlockState stdOverlay = BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "slab_lo", paintSource, null);
        IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "slab_lo", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION3);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        list.add(model2);
        return list;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState bs = world.func_180495_p(pos);
        return bs.func_185904_a() == Material.field_151575_d ? 20 : super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151575_d ? 5 : super.getFireSpreadSpeed(world, pos, face);
    }

    public boolean doesSideBlockRendering(IBlockState bs, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_176225_a(IBlockState ourBlockState, IBlockAccess worldIn, BlockPos here, EnumFacing side) {
        BlockPos there = here.func_177972_a(side);
        IBlockState blockState2 = worldIn.func_180495_p(there);
        Block block2 = blockState2.func_177230_c();
        if (block2 instanceof BlockPaintedSlab) {
            BlockPaintedSlab otherBlock = (BlockPaintedSlab)block2;
            if (side == EnumFacing.UP) {
                if (!this.func_176552_j() && ourBlockState.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
                    return true;
                }
                if (!otherBlock.func_176552_j() && blockState2.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                    return true;
                }
                IBlockState ourPaint = this.func_176552_j() ? this.getPaintSource2(ourBlockState, worldIn, here) : this.getPaintSource(ourBlockState, worldIn, here);
                IBlockState otherPaint = this.getPaintSource(blockState2, worldIn, there);
                return ourPaint != otherPaint;
            }
            if (side == EnumFacing.DOWN) {
                if (!this.func_176552_j() && ourBlockState.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                    return true;
                }
                if (!otherBlock.func_176552_j() && blockState2.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM) {
                    return true;
                }
                IBlockState ourPaint = this.getPaintSource(ourBlockState, worldIn, here);
                IBlockState otherPaint = otherBlock.func_176552_j() ? this.getPaintSource2(blockState2, worldIn, there) : this.getPaintSource(blockState2, worldIn, there);
                return ourPaint != otherPaint;
            }
            if (this.func_176552_j()) {
                if (!otherBlock.func_176552_j()) {
                    return true;
                }
                return this.getPaintSource(ourBlockState, worldIn, here) != this.getPaintSource(blockState2, worldIn, there) || this.getPaintSource2(ourBlockState, worldIn, here) != this.getPaintSource2(blockState2, worldIn, there);
            }
            if (!otherBlock.func_176552_j() && blockState2.func_177229_b((IProperty)field_176554_a) != ourBlockState.func_177229_b((IProperty)field_176554_a)) {
                return true;
            }
            IBlockState paintSource = this.getPaintSource(ourBlockState, worldIn, here);
            if (otherBlock.func_176552_j() && ourBlockState.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                return paintSource != this.getPaintSource2(blockState2, worldIn, there);
            }
            return paintSource != this.getPaintSource(blockState2, worldIn, there);
        }
        return super.func_176225_a(ourBlockState, worldIn, here, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
        for (BlockSlab.EnumBlockHalf half : BlockSlab.EnumBlockHalf.values()) {
            IBlockState paintSource;
            if (!this.func_176552_j() && half != state.func_177229_b((IProperty)field_176554_a)) continue;
            boolean isTop = half == BlockSlab.EnumBlockHalf.TOP;
            IBlockState iBlockState = paintSource = isTop ? this.getPaintSource2(state, world, pos) : this.getPaintSource(state, world, pos);
            if (!PainterUtil2.canRenderInLayer(paintSource, blockLayer)) continue;
            quadCollector.addFriendlybakedModel(blockLayer, PaintRegistry.getModel(IBakedModel.class, isTop ? "slab_hi" : "slab_lo", paintSource, null), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    public static class BlockPaintedDoubleSlab
    extends BlockPaintedSlab {
        public BlockPaintedDoubleSlab(Material material, String name, Block halfVariant, SoundType sound) {
            super(material, name, halfVariant);
            this.func_149672_a(sound);
        }

        public boolean func_176552_j() {
            return true;
        }
    }

    public static class BlockPaintedHalfSlab
    extends BlockPaintedSlab {
        public BlockPaintedHalfSlab(Material material, String name, SoundType sound) {
            super(material, name, null);
            this.func_149672_a(sound);
        }

        public boolean func_176552_j() {
            return false;
        }
    }
}

